/*
 * LocalFilterPanel.java
 *
 * Created on 25 Октябрь 2007 г., 17:45
 */

package org.netbeans.modules.php.dbgp.ui;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import org.netbeans.modules.php.dbgp.models.VariablesModelFilter;
import org.netbeans.modules.php.dbgp.models.VariablesModelFilter.FilterType;



/**
 *
 * @author  den
 */
public class LocalFilterPanel extends javax.swing.JPanel {
    
    private static final long serialVersionUID = -523385854753396290L;
    
    /** Creates new form LocalFilterPanel */
    public LocalFilterPanel() {
        initComponents();
        init();
    }

    public FilterType[] getSelectedTypes() {
        List<FilterType> result = new LinkedList<FilterType>();
        if ( myScalars.isSelected() ) {
            result.add( FilterType.SCALARS);
        }
        if ( myArray.isSelected() ) {
            result.add( FilterType.ARRAY );
        }
        if ( myObject.isSelected() ) {
            result.add( FilterType.OBJECT );
        }
        if ( myResource.isSelected() ) {
            result.add( FilterType.RESOURCE );
        }
        if ( myNull.isSelected() ) {
            result.add( FilterType.NULL );
        }
        if ( myUninit.isSelected() ) {
            result.add( FilterType.UNINIT);
        }
        if ( mySuperglobal.isSelected() ) {
            result.add( FilterType.SUPERGLOBALS);
        }
        return result.toArray( new FilterType[ result.size()] );
    }

    private void init() {
        FilterType[] types = VariablesModelFilter.getFilters();
        if ( types == null ) {
            return;
        }
        Set<FilterType> set = new HashSet<FilterType>( Arrays.asList( types ) );
        myScalars.setSelected( set.contains( FilterType.SCALARS));
        myArray.setSelected( set.contains( FilterType.ARRAY));
        myObject.setSelected( set.contains( FilterType.OBJECT));
        myResource.setSelected( set.contains(FilterType.RESOURCE)); 
        myNull.setSelected( set.contains( FilterType.NULL));
        myUninit.setSelected( set.contains(FilterType.UNINIT));
        mySuperglobal.setSelected( set.contains(FilterType.SUPERGLOBALS ));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mySelectLbl = new javax.swing.JLabel();
        myScalars = new javax.swing.JCheckBox();
        myArray = new javax.swing.JCheckBox();
        myObject = new javax.swing.JCheckBox();
        myResource = new javax.swing.JCheckBox();
        myNull = new javax.swing.JCheckBox();
        myUninit = new javax.swing.JCheckBox();
        mySuperglobal = new javax.swing.JCheckBox();

        org.openide.awt.Mnemonics.setLocalizedText(mySelectLbl, org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LBL_Select")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(myScalars, org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LBL_Scalars")); // NOI18N
        myScalars.setActionCommand(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LBL_Scalars")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(myArray, org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LBL_Array")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(myObject, org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LBL_Object")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(myResource, org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LBL_Resource")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(myNull, org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LBL_Null")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(myUninit, org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LBL_Uninit")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(mySuperglobal, org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LBL_Superglobal")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(mySelectLbl)
                    .add(layout.createSequentialGroup()
                        .add(10, 10, 10)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(myArray)
                            .add(myScalars)
                            .add(myObject)
                            .add(myResource)
                            .add(myNull)
                            .add(myUninit)
                            .add(mySuperglobal))))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(mySelectLbl)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(myScalars)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(myArray)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(myObject)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(myResource)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(myNull)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(myUninit)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(mySuperglobal)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        myScalars.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "A11_Scalars")); // NOI18N
        myArray.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "A11_Array")); // NOI18N
        myObject.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "A11_Object")); // NOI18N
        myResource.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "A11_Resource")); // NOI18N
        myNull.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "A11_Null")); // NOI18N
        myUninit.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "A11_Uninit")); // NOI18N
        mySuperglobal.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "A11_Superglobal")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox myArray;
    private javax.swing.JCheckBox myNull;
    private javax.swing.JCheckBox myObject;
    private javax.swing.JCheckBox myResource;
    private javax.swing.JCheckBox myScalars;
    private javax.swing.JLabel mySelectLbl;
    private javax.swing.JCheckBox mySuperglobal;
    private javax.swing.JCheckBox myUninit;
    // End of variables declaration//GEN-END:variables

}
