/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.print.impl.util;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;

import static org.netbeans.modules.print.api.PrintUtil.*;

/**
 * @author Vladimir Yaroslavskiy
 * @version 2005.12.14
 */
public final class Util {

  private Util() {}

  /**
   * Converts string to integer.
   * @param value string data
   * @return integer value
   */
  public static int getInt(String value) {
    try {
      return Integer.parseInt(value);
    }
    catch (NumberFormatException e) {
      return -1;
    }
  }

  /**
   * Rounds double to integer.
   * @param value double data
   * @return integer value
   */
  public static int round(double value) {
    return (int) Math.ceil(value);
  }

  /**
   * Returns formated string 'page' of 'count'.
   * @param page given page
   * @param count given count
   * @return formated string 'page' of 'count'
   */
  public static String getPageOfCount(String page, String count) {
    return i18n(Util.class, "LBL_Page_of_Count", page, count); // NOI18N
  }

  /**
   * Returns formated string 'row'.'column'.
   * @param row given row
   * @param column given column
   * @return formated string 'row'.'column'
   */
  public static String getRowColumn(String row, String column) {
    return i18n(Util.class, "LBL_Row.Column", row, column); // NOI18N
  }

  /**
   * Returns corrected graphics.
   * @param g given graphics
   * @return corrected graphics
   */
  public static Graphics2D getGraphics(Graphics g) {
    Graphics2D graphics = (Graphics2D) g;

    graphics.setRenderingHint(
      RenderingHints.KEY_ANTIALIASING,
      RenderingHints.VALUE_ANTIALIAS_ON);

    graphics.setRenderingHint(
      RenderingHints.KEY_FRACTIONALMETRICS,
      RenderingHints.VALUE_FRACTIONALMETRICS_ON);

    return graphics;
  }

  /**
   * Replaces in source all occurences.
   * @param source a source string
   * @param searchFor a string which should be replaced
   * @param replaceWith a string which replaces searchFor
   * @return source with replaced content
   */
  public static String replace(String source, String searchFor, String replaceWith) {
    if (source == null) {
      return null;
    }
    if (searchFor == null || searchFor.length() == 0) {
      return null;
    }
    int k = 0;
    int found = source.indexOf(searchFor, k);
    StringBuffer buffer = new StringBuffer();

    while (true) {
      if (found == -1) {
        break;
      }
      buffer.append(source.substring(k, found));
      buffer.append(replaceWith);

      k = found + searchFor.length();
      found = source.indexOf(searchFor, k);
    }
    if (k > 0) {
        buffer.append(source.substring(k));
        return buffer.toString();
    }
    else {
      return source;
    }
  }

  /**
   * Returns print and preview option.
   * @return print and preview option
   */
  public static Option getOption() {
    return OPTION;
  }

  public static final FontRenderContext FONT_RENDER_CONTEXT
    = new FontRenderContext(null, true, true);

  private static final Option OPTION = new Option();
}
