/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.masterfs.providers;

import org.netbeans.modules.masterfs.providers.AutoMountProvider;

/**
 *
 * An object that implements FileSystemProvider have chance to affect behaviour of
 * MasterFileSystem. MasterFileSystem delegates its functionality to mounted FileSystems.
 * So, behaviour of MasterFileSystem can be affected easily by mounting its own
 * implemenation of FileSystem.
 *
 * <P>There are two ways how to mount FileSystem into MasterFileSystem:
 * <UL>
 * <LI> <b>automatic mounting</b> means,
 * that there is not necessary to call MountSupport
 * to mount filesystem into MasterFileSystem. On the contrary MasterFileSystem
 * invokes individual AutoMountProviders to obtain instance of FileSystem, that should
 * be mounted. Then {@link org.netbeans.modules.masterfs.providers.AutoMountProvider}
 * must be able to return best suited filesystem for passed mount point or null.
 *

 * </LI>
 * <LI> <b>user mounting</b> is simply {@link org.netbeans.modules.masterfs.providers.MountSupport},
 * which is API, that has two methods mount and unmount.
 * </LI>
 * </UL> <P>
 *
 *
 * @see org.netbeans.modules.masterfs.providers.MountSupport
 * @see org.netbeans.modules.masterfs.providers.AutoMountProvider
 * @author  rm111737
 */
public abstract interface FileSystemProvider {
    /**
     * Implementation of method initialize may support:
     * <UL>
     * <LI> <b>automatic mounting</b>, then method initialize mustn't return null. </LI>
     * <LI> <b>user mounting</b>, then MountSupport passed to method initalize needs to be kept.</LI>
     * <LI> both above mentioned</LI>
     * </UL>
     * @param mSupport instance of MountSupport provided by MasterFileSystem
     * @return  instance of  AutoMountProvider if there is supported <b>automatic mounting</b>
     */
    public abstract AutoMountProvider initialize (MountSupport mSupport);

}
