<%@page contentType="text/html"%>
<%@page pageEncoding="UTF-8"%>
<%@ page import="org.netbeans.server.uihandler.statistics.Actions" %>
<%@ page import="org.netbeans.lib.uihandler.InputGesture" %>
<%@ page import="java.util.*" %>
<%@ taglib uri="/WEB-INF/chart-tag.tld" prefix="chart" %>
<%@ taglib uri="/WEB-INF/statistics.tld" prefix="ui" %>

<head>
<jsp:include page="../template/header.jsp"/>
<ui:useStatistic name="Actions"/>

<a href="http://www.netbeans.org/index.html">HOME</a> 
/ 
<a href="http://www.netbeans.org/community/index.html">Community</a>
/
<a href="index.jsp">Analytics</a>
/
Graph
/
Actions

<td class="valign-top b-right full-width">

    <div class="f-page-cell bg-sky" >
        <h2>What actions are used by you and others?</h2>
        
        <p>
            This statistic allows you to see the actions that you and
            others were using during the work. The actions names are the
            actual names of the classes in the application and each of
            them is associated with number of its invocations. This 
            page usually displays a "top ten" of the most used actions,
            however it also offers a way to customize the list of actions
            by use of regular expressions. See <a href="#query">bottom of this page</a> 
            for details.
        </p>
    </div>
    
    <table width="100%">
        <% 
        Map<String,Integer> last = (Map<String,Integer>)pageContext.getAttribute("lastActionsTop10");
        if (last != null) {
        %>
        <tr width="100%">
            <td width="100%">
                <div align="center">
                    <b>Your Last Session</b>
                    <p>
                        This is the top ten of actions you have used during your
                        last session.
                    </p>
                    <chart:pie collection="lastActionsTop10" category="key" value="value" createLegend="false"/>
                </div>
            </td>
        </tr>
        <% }
        Map<String,Integer> user = (Map<String,Integer>)pageContext.getAttribute("userActionsTop10");

        if (user != null) {
        %>
        <tr width="100%">
            <td width="100%">
                <div align="center">
                    <b>All Your Sessions</b>
                    <p>
                        According to our database, this is the list of most 
                        used actions in all your submitted sessions.
                    </p>
                    <chart:pie collection="userActionsTop10" category="key" value="value" createLegend="false"/>
                </div>
            </td>
        </tr>
        <% } 
        
        
        Map<String,Integer> all = (Map<String,Integer>)pageContext.getAttribute("globalActionsTop10");

        if (all != null) {
        %>
        <tr width="100%">
            <td width="100%">
                <div align="center">
                    <b>Global Statistics</b>
                    <p></p>
                    <chart:pie collection="globalActionsTop10" category="key" value="value" createLegend="false"/>
                </div>
            </td>
        </tr>
        <tr>
            <td>
            <table cellpadding="5" width="100%" >
            <thead class="tblheader">
                <th width="90%">Action Name</th>
                <th>Invocations</th>
            </thead>
            <% for (Map.Entry<String,Integer> entry : all.entrySet()) { %>
                <tr>
                    <td class="tbltd1"><% out.println(entry.getKey()); %></td>
                    <td class="tbltd1"><% out.println(entry.getValue()); %></td>
                </tr>
            <% } %>
            </table>
            </td>
        </tr>
        <% } %>
    </table>
    
    <hr>
    
    <div class="f-page-cell bg-sky" >
    <h3><a name="query"></a>Restrict the Query!</h3>
    <p>
        Showing just a top ten of most used actions is interesting, but not
        sufficient. In order to understand the behaviour of users in
        particular area of the application, it is much better to see just 
        a <q>local topten</q> - e.g. only list of the most often used actions
        from profiler, debugger or window system. 
    </p>
    <p>
        This interactive statistic page allows you to restrict your query
        to show only actions matching specific <a href="http://java.sun.com/javase/6/docs/api/java/util/regex/Pattern.html">
            regular expression
        </a> pattern. That way you can use for example <code>.*profiler.*</code>
        to see actions defined just by the profiler module, or you can use
        <code>.*profiler.*|.*debugger.*</code> to compare the usage of
        profiler with usage of debugger. The expression <code>.*</code> means
        everything. The "<code>|</code>" means "or". For more advanced
        usages read the <a href="http://java.sun.com/javase/6/docs/api/java/util/regex/Pattern.html">
            JDK documentation.
        </a>.
    </p>
    
    <p>
        
    </p>
        
    <form method="get" action="<% out.print(HttpUtils.getRequestURL(request)); %>" >
        <table width="100%">
           <tr>
            <td>Include pattern:</td>
            <td>Exclude pattern:</td>
            <td>Number of lines:</td>
            <td></td>
           </tr>
           <tr>
            <td><input type="text" name="ActionsIncludes" value='${ActionsIncludes!=null?ActionsIncludes:".*"}'/></td>
            <td><input type="text" name="ActionsExcludes" value="${ActionsExcludes}"/></td>
            <td><input type="text" name="ActionsCount" value='${ActionsCount!=null?ActionsCount:"10"}'/></td>
            <td><input type="submit"/></td>
           </tr>
        </table>
    </form>
    
    </div>
</center>
<jsp:include page="../template/footer.jsp"/>
