/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.exceptions.web.action;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.exceptions.web.*;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForward;
import org.netbeans.modules.exceptions.entity.Exceptions;
import org.netbeans.modules.exceptions.entity.Issue;
import org.netbeans.modules.exceptions.utils.PersistenceUtils;
/**
 *
 * @author Jan Horvath
 * @version
 */

public class MapIssueAction extends Action {
    
    private static final String EXP = "[^0-9]*([0-9]*)$";
    private static final Pattern p = Pattern.compile(EXP);
    
    /* forward name="success" path="" */
    private final static String SUCCESS = "success";
    private final static String ERROR = "error";
    private final static DateFormat formatter = new SimpleDateFormat("yyyyMMddhhmm");
    
    static final Logger LOG = Logger.getLogger(MapIssueAction.class.getName());
    
    /**
     * This is the action called from the Struts framework.
     * @param mapping The ActionMapping used to select this instance.
     * @param form The optional ActionForm bean for this request.
     * @param request The HTTP Request we are processing.
     * @param response The HTTP Response we are processing.
     * @throws java.lang.Exception
     * @return
     */
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        Integer duplicateId = null;
        if (request.getParameter("reset") != null) {
            //Exceptions.Status;
            System.err.println("*** reset");
            List l = PersistenceUtils.getInstance().executeNativeQuery("select  id " +
                    "from exceptions where (status & " + 
                    Exceptions.Status.ISSUEZILLA_TRANSFER.intValue() + ") <> 0");
            for (Iterator it = l.iterator(); it.hasNext();) {
                Vector v = (Vector) it.next();
                Exceptions e = (Exceptions) PersistenceUtils.getInstance().getEntity(Exceptions.class, v.elementAt(0));
                e.setIssuezillaTransfer(false);
                PersistenceUtils.getInstance().merge(e);
            }
            request.setAttribute("message", "reset done");
            return mapping.findForward(SUCCESS);
        }
        
        Integer id = null;
        try {
            id = new Integer(request.getParameter("id"));
        } catch (NumberFormatException e) {
            request.setAttribute("message", "id is not a number");
            return mapping.findForward(ERROR);
        }
        
        
        if (request.getParameter("update_issue") == null) {
            String sum = request.getParameter("sum");
            Integer issuezillaId = null;
            try {
                issuezillaId = new Integer(request.getParameter("issue"));
            } catch (NumberFormatException e) {
                request.setAttribute("message", "id or issue is not a number");
                return mapping.findForward(ERROR);
            }
            
            if (!md5sum(id + "=" + issuezillaId).equals(sum)) {
                request.setAttribute("message", "wrong MD5 checksum: " + md5sum(id + "=" + issuezillaId) + " != " + sum);
                return mapping.findForward(ERROR);
            }
            Exceptions exceptions = (Exceptions) PersistenceUtils.getInstance().getEntity(Exceptions.class, id);
            exceptions.setIssuezillaid(issuezillaId);
            PersistenceUtils.getInstance().merge(exceptions);
            request.setAttribute("exceptions", exceptions);
            request.setAttribute("message", "exception was updated");
            return mapping.findForward(SUCCESS);
        } else {
            Issue issue = (Issue) PersistenceUtils.getInstance().getEntity(Issue.class, id);
            if (issue == null) {
                issue = new Issue();
                issue.setIssueId(id);
            }
            StringBuffer check = new StringBuffer();
            String s;
            
            s = decodeParameter(request, "assigned_to");
            if (s != null) check.append("assigned_to=" + s);
            issue.setAssignedTo(s);
            
            s = decodeParameter(request, "component");
            if (s != null) check.append("component=" + s);
            issue.setComponent(s);
            
            s = decodeParameter(request, "creation_ts");
            if (s != null) check.append("creation_ts=" + s);
            issue.setCreationTs(getDate(s));
            
            s = decodeParameter(request, "delta_ts");
            if (s != null) check.append("delta_ts=" + s);
            issue.setDeltaTs(getDate(s));
            
            s = decodeParameter(request, "issue_file_loc");
            if (s != null) check.append("issue_file_loc=" + s);
            issue.setIssueFileLoc(s);
            
            s = decodeParameter(request, "id");
            if (s != null) check.append("id=" + s);
            
            s = decodeParameter(request, "issue_status");
            if (s != null) check.append("issue_status=" + s);
            issue.setIssueStatus(s);
            
            s = decodeParameter(request, "issue_type");
            if (s != null) check.append("issue_type=" + s);
            issue.setIssueType(s);
            
            s = decodeParameter(request, "keyword");
            if (s != null) check.append("keyword=" + s);
            issue.setKeyword(s);
            
            s = decodeParameter(request, "op_sys");
            if (s != null) check.append("op_sys=" + s);
            issue.setOpSys(s);
            
            s = decodeParameter(request, "priority");
            if (s != null) check.append("priority=" + s);
            issue.setPriority(s);
            
            s = decodeParameter(request, "qa_contact");
            if (s != null) check.append("qa_contact=" + s);
            issue.setQaContact(s);
            
            s = decodeParameter(request, "rep_platform");
            if (s != null) check.append("rep_platform=" + s);
            issue.setRepPlatform(s);
            
            s = decodeParameter(request, "reporter");
            if (s != null) check.append("reporter=" + s);
            issue.setReporter(s);
            
            s = decodeParameter(request, "resolution");
            if (s != null) check.append("resolution=" + s);
            issue.setResolution(s);
            
            s = decodeParameter(request, "short_desc");
            if (s != null) check.append("short_desc=" + s);
            issue.setShortDesc(s);
            
            s = decodeParameter(request, "status_whiteboard");
            if (s != null) check.append("status_whiteboard=" + s);
            issue.setStatusWhiteboard(s);
            
            s = decodeParameter(request, "subcomponent");
            if (s != null) check.append("subcomponent=" + s);
            issue.setSubcomponent(s);
            
            s = decodeParameter(request, "target_milestone");
            if (s != null) check.append("target_milestone=" + s);
            issue.setTargetMilestone(s);
            
            s = decodeParameter(request, "version");
            if (s != null) check.append("version=" + s);
            issue.setVersion(decodeParameter(request, "version"));
            
            s = decodeParameter(request, "votes");
            if (s != null) check.append("votes=" + s);
            issue.setVotes(getInteger(s));
            
            s = decodeParameter(request, "duplicate_id");
            if (s != null) check.append("duplicate_id=" + s);
            duplicateId = getInteger(s);
            
            if (!md5sum(check.toString()).equals(request.getParameter("sum"))) {
                Logger.getLogger("global").log(Level.SEVERE, "incorrect MD5 sum: " + check);
                request.setAttribute("message", "wrong MD5 checksum");
                return mapping.findForward(ERROR);
            }
            Matcher m = p.matcher(issue.getIssueFileLoc());
            if (m.find()) {
                try {
                    Integer excId = new Integer(m.group(1));
                    Exceptions exc = (Exceptions) PersistenceUtils.getInstance().getEntity(Exceptions.class, excId);
                    if (exc != null) {
                        exc.setIssuezillaid(id);
                        PersistenceUtils.getInstance().merge(exc);
                    }
                } catch (NumberFormatException e) {
                }
            }
            if (duplicateId != null) {
                LOG.log(Level.FINE, "updating duplicate " + duplicateId + " to " + id);
                List<Exceptions> excs = PersistenceUtils.getInstance()
                        .executeNamedQuery("Exceptions.findByIssuezillaid", Collections.singletonMap("issuezillaid", (Object) duplicateId));
                
                for (Exceptions exceptions : excs) {
                    if (exceptions != null) {
                        exceptions.setIssuezillaid(id);
                        LOG.log(Level.FINE, "updating duplicate exception #" + exceptions.getId());
                        PersistenceUtils.getInstance().merge(exceptions);
                    }
                }
            }
            PersistenceUtils.getInstance().merge(issue);
            request.setAttribute("message", "issue was updated");
            return mapping.findForward(SUCCESS);
        }
    }
    
    private String decodeParameter(HttpServletRequest request, String name) {
        String p = request.getParameter(name);
        if (p == null) return null;
        try {
            return java.net.URLDecoder.decode(p, "UTF-8");
        } catch (UnsupportedEncodingException ex) {
            Logger.getLogger("global").log(Level.SEVERE, null, ex);
        }
        return p;
    }
    
    private Integer getInteger(String s) {
        Integer i = null;
        if (s != null) {
            try {
                i = new Integer(s);
            } catch (NumberFormatException e) {
            }
        }
        return i;
    }
    
    private Date getDate(String s) {
        Date date = null;
        if (s != null) {
            try {
                date = (java.util.Date) formatter.parse(s);
            } catch (ParseException ex) {
                Logger.getLogger("global").log(Level.SEVERE, null, ex);
            }
        }
        return date;
    }
        
        
        private String md5sum(String str) {
            StringBuffer sum = new StringBuffer();
            try     {
                java.security.MessageDigest md5 = java.security.MessageDigest.getInstance("MD5");
                md5.update(str.getBytes());
                byte[] sign = md5.digest();
                for (byte b : sign) {
                    sum.append(byteToHex(b));
                }
            } catch (NoSuchAlgorithmException ex) {
                java.util.logging.Logger.getLogger("global").log(java.util.logging.Level.SEVERE,
                        ex.getMessage(), ex);
            }
            return sum.toString();
        }
        
        private String byteToHex(byte data) {
            StringBuffer buf = new StringBuffer();
            buf.append(Character.forDigit((data >>> 4) & 0x0F, 16));
            buf.append(Character.forDigit((data & 0x0F), 16));
            return buf.toString();
        }
    }
