/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Ralph Krueger.
 */

package org.netbeans.modules.changelog.html;


import java.util.*;
import org.openide.*;
import org.openide.util.*;

/**
 * Holds server specific information for generating html output links.
 *
 * @author  ralph
 */
public class ChangeLogHTMLService extends ServiceType {

    public static final String REVISION = "revisionURL"; //NOI18N
    public static final String DIFF = "diffURL"; //NOI18N
    public static final String PREFIX = "cvsRootPrefix"; //NOI18N


    /** Holds value of property cvsRootPrefix. */
    private String cvsRootPrefix;

    /** Holds value of property diffURL. */
    private String diffURL;
    
    /** Holds value of property revisionURL. */
    private String revisionURL;
    
    private static final long serialVersionUID = -1717495349319475009L;
    
    public ChangeLogHTMLService() {
    }
    
    /** Get context help for this service type.
     * @return context help
     */
    public HelpCtx getHelpCtx() {
        return new HelpCtx(ChangeLogHTMLService.class);
    }    
    
    /** Getter for property cvsRootPrefix.
     * @return Value of property cvsRootPrefix.
     */
    public String getCvsRootPrefix() {
        return this.cvsRootPrefix;
    }    
    
    /** Setter for property cvsRootPrefix.
     * @param cvsRootPrefix New value of property cvsRootPrefix.
     */
    public void setCvsRootPrefix(String cvsRootPrefix) {
        String old = this.cvsRootPrefix;
        this.cvsRootPrefix = cvsRootPrefix;
        firePropertyChange(PREFIX, old, cvsRootPrefix);
    }
    
    /** Getter for property diffURL.
     * @return Value of property diffURL.
     */
    public String getDiffURL() {
        return this.diffURL;
    }
    
    /** Setter for property diffURL.
     * @param diffURL New value of property diffURL.
     */
    public void setDiffURL(String diffURL) {
        String old = this.diffURL;
        this.diffURL = diffURL;
        firePropertyChange(DIFF, old, diffURL);
    }
    
    /** Getter for property revisionURL.
     * @return Value of property revisionURL.
     */
    public String getRevisionURL() {
        return this.revisionURL;
    }
    
    /** Setter for property revisionURL.
     * @param revisionURL New value of property revisionURL.
     */
    public void setRevisionURL(String revisionURL) {
        String old = this.revisionURL;
        this.revisionURL = revisionURL;
        firePropertyChange(REVISION,  old, revisionURL);
    }
    
    
    public Object clone()  {
        ChangeLogHTMLService changelog = new ChangeLogHTMLService();
        changelog.setCvsRootPrefix(getCvsRootPrefix());
        changelog.setDiffURL(getDiffURL());
        changelog.setRevisionURL(getRevisionURL());
        return changelog;
    }
    
}
