/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */


package org.netbeans.modules.changelog;

/**
 *
 * @author  Milos Kleint, ralph krueger
 */
import org.netbeans.modules.javacvs.events.CommandDisplayerAdapter;
import org.netbeans.modules.javacvs.commands.*;
import org.netbeans.modules.cvsclient.*;

import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;


import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import java.util.*;
import java.io.*;
import org.openide.filesystems.*;
import org.openide.*;
import org.openide.loaders.*;
import org.openide.util.*;
import javax.swing.*;
import java.awt.Dialog;
import java.awt.event.*;

public class ChangeLogDisplayer extends CommandDisplayerAdapter {
    
    private static final String INITIAL_REV = "Initial revision"; //NOI18N
    private static final String WAS_ADDED_ON_BRANCH = "was initially added on branch"; //NOI18N
    
    private int commandCount = 0;
    private int finishedCommandCount = 0;
    private long revisionsNumber = 0;
    private boolean errorsOccured = false;
    
    private HashMap fileObjectMap;
    
    private RE messageRE = null;
    
    private ChangeLogProcessor processor;
    
    /** Creates new ChangeLogDisplayer */
    public ChangeLogDisplayer(ChangeLogProcessor proces) {
        fileObjectMap = new HashMap(10);
        processor = proces;
    }
    
    
    /**
     * adds fileobjects to a map of selected fileobjects for this action.
     * Is needed to convert correctly the resulting files back to
     * fileobjects.
     */ 
    public void addFileObjects(FileObject[] fos) {
        if (fos != null) {
            for (int i=0; i < fos.length; i++) {
                File file = FileSystemCommand.toFile(fos[i]);
                if (file != null) {
                    fileObjectMap.put(file, fos[i]);
                }
            }
        }
    }

    public synchronized void setNumberOfCommands(int number) {
        commandCount = number;
    }
    
    public int getNumberOfCommand() {
        return commandCount;
    }
    
    
    public synchronized void showFinishedCommand() {
//        System.out.println("finished 1 status command..");
        finishedCommandCount = finishedCommandCount + 1;
        if (finishedCommandCount == commandCount) {
            showDialog();
        }
    }
    
    public synchronized void showExecutionFailed(Exception exception) {
        errorsOccured = true;
        System.out.println("exc=" + exception);
        exception.printStackTrace();
        finishedCommandCount = finishedCommandCount + 1;
        if (finishedCommandCount == commandCount) {
            showDialog();
        }
    }

    public synchronized void showStartCommand() {
        
    }
    
    private java.util.List extractBranches(LogInformation info) {
        LinkedList list = new LinkedList();
        if (info.getAllSymbolicNames() != null) {
            Iterator it = info.getAllSymbolicNames().iterator();
            while (it.hasNext()) {
                LogInformation.SymName name = (LogInformation.SymName)it.next();
                // performance related condition??
                if (name.getRevision().indexOf(".0") > 0) { 
                    int[] arr = ChangeLogUtils.convertRevisionToIntArray(name.getRevision());
                    if (arr[arr.length - 2] == 0) {
                        // needs to be performance improved!!!!
                        
                        name.setRevision(ChangeLogUtils.convertIntArrayToRevision(arr).intern());
                        list.add(name);
                    }
                }
            }
        }
        return list;
    }
    
    public synchronized void showFileInfoGenerated(FileInfoContainer info) {
        if (info.getClass().equals(LogInformation.class)) {
            LogInformation lInfo = (LogInformation)info;
            LogInfoRevision.LogInfoHeader header = createHeader(lInfo);
            List branchList = extractBranches(lInfo);
            boolean include = true;
            Iterator it =lInfo.getRevisionList().iterator();
            while (it.hasNext()) {
                include = true;
                LogInformation.Revision rev = (LogInformation.Revision)it.next();
                // don't include revision 1.1 created on background when
                // the file is added on the branch..
                if (rev.getState() != null &&
                    rev.getMessage() != null &&
                    rev.getNumber() != null &&
                    rev.getState().equals("dead") && //NOI18N
                    rev.getNumber().equals("1.1") && //NOI18N
                    rev.getMessage().indexOf(WAS_ADDED_ON_BRANCH) > 0) {
                        continue;
                }
                // don't include the revision created during import command.
                // not sure if the condition here is bulletproof.
                if (rev.getMessage() != null &&
                    rev.getNumber() != null &&
                    rev.getNumber().equals("1.1") && //NOI18N
                    rev.getMessage().indexOf(INITIAL_REV) >= 0) {
                        continue;
                }
                if (processor.messageMatchesFilterPattern(rev.getMessage())) {
                    LogInfoRevision revision = createRevision(rev, header);
                    revision.setBranch(findBranchInSymNamesList(branchList, revision.getNumber()));
                    processor.addRevision(revision, rev.getMessage());
                }
            }
        }
    }

    /**
     * TODO:
     * can be optimized by first sorting from longest to shortest branch number..
     */
    private String findBranchInSymNamesList(List list, String revisionNumber) {
        Iterator it = list.iterator();
        if (revisionNumber.indexOf('.') == revisionNumber.lastIndexOf('.')) {
            return null;
        }
        String branch = null;
        String longestMatch = "";
        while (it.hasNext()) {
            LogInformation.SymName name = (LogInformation.SymName)it.next();
            if (revisionNumber.startsWith(name.getRevision())) {
                if (name.getRevision().length() > longestMatch.length()) {
                    branch = name.getName();
                    longestMatch = name.getRevision();
                }
            }
        }
        return branch;
    }
    
    private void showDialog() {
        processor.finishProcessing();
    }
    
    
    
    
    private LogInfoRevision.LogInfoHeader createHeader(LogInformation info) {
        LogInfoRevision.LogInfoHeader header = new LogInfoRevision.LogInfoHeader();
        header.setAccessList(info.getAccessList());
        header.setBranch(info.getBranch());
        header.setDescription(info.getDescription());
        header.setFile(info.getFile());
        header.setHeadRevision(info.getHeadRevision());
        header.setKeywordSubstitution(info.getKeywordSubstitution());
        header.setLocks(info.getLocks());
        header.setRepositoryFilename(info.getRepositoryFilename());
        header.setSelectedRevisions(info.getSelectedRevisions());
        header.setTotalRevisions(info.getTotalRevisions());
        return header;
    }
    
    private LogInfoRevision createRevision(LogInformation.Revision jcvsRev, 
                                           LogInfoRevision.LogInfoHeader header) {
        LogInfoRevision rev = new LogInfoRevision(header.getFile());
        rev.setAuthor(jcvsRev.getAuthor());
//        rev.setBranches(jcvsRev.getBranches());
        rev.setDate(jcvsRev.getDate());
        rev.setLines(jcvsRev.getLines());
        rev.setLogInfoHeader(header);
        rev.setNumber(jcvsRev.getNumber());
        rev.setState(jcvsRev.getState());
        return rev;
    }
        
}
