/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.refactoring.moveclass;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.refactoring.PersistenceRefactoringUtil;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/**
 * This class handles renaming managed entity class reference
 * in persistence.xml when it is moved to an another package.
 *
 * @author Erno Mononen
 */
public class PersistenceXmlMoveClassRefactoring {
    
    /**
     * Creates a new instance of PersistenceXmlMoveClassRefactoring
     */
    public PersistenceXmlMoveClassRefactoring() {
    }
    
    public Problem prepare(MoveClassRefactoring moveClassRefactor,
            Collection resources, RefactoringElementsBag refactoringElements) {
        
        Problem problem = null;
        
        for (Iterator it = resources.iterator(); it.hasNext();) {
            Resource elem = (Resource) it.next();
            
            for (Iterator it2 = elem.getClassifiers().iterator(); it2.hasNext();) {
                JavaClass jClass = (JavaClass) it2.next();
                
                String newName = moveClassRefactor.getTargetPackageName(elem) + "." + jClass.getSimpleName();
                for (FileObject ddFile : PersistenceRefactoringUtil.getPersistence(jClass)) {
                    PUDataObject dataObject = ProviderUtil.getPUDataObject(ddFile);
                    
                    if (!ProviderUtil.isValid(dataObject)){
                        Problem newProblem =
                                new Problem(false, NbBundle.getMessage(PersistenceXmlMoveClassRefactoring.class, "TXT_PersistenceXmlInvalidProblem", ddFile.getPath()));
                        problem = Utility.addProblemsToEnd(problem, newProblem);
                        continue;
                    }
                    
                    PersistenceUnit[] persistenceUnits = ProviderUtil.getPersistenceUnits(dataObject);
                    
                    for (int i = 0; i < persistenceUnits.length; i++) {
                        PersistenceUnit unit = persistenceUnits[i];
                        
                        for (int j = 0; j < unit.getClass2().length; j++) {
                            
                            if (unit.getClass2()[j].equals(jClass.getName())){
                                
                                RefactoringElementImplementation refactoringElem =
                                        new PersistenceXmlMoveClassRefactoringElement(unit, jClass.getName(), newName, dataObject, ddFile);
                                
                                refactoringElements.add(moveClassRefactor, refactoringElem);
                            }
                            
                        }
                    }
                }
            }
            
        }
        return problem;
    }
    
    /**
     * Move class element for persistence.xml
     */
    private static class PersistenceXmlMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {
        
        private PersistenceUnit persistenceUnit;
        private PUDataObject puDataObject;
        
        /** Creates a new instance of PersistenceXmlMoveClassRefactoringElement */
        public PersistenceXmlMoveClassRefactoringElement(PersistenceUnit persistenceUnit,
                String oldName,  String newName, PUDataObject puDataObject, FileObject parentFile) {
            this.oldName = oldName;
            this.newName = newName;
            this.persistenceUnit = persistenceUnit;
            this.puDataObject = puDataObject;
            this.parentFile = parentFile;
        }
        
        /**
         * Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(PersistenceXmlMoveClassRefactoring.class, "TXT_PersistenceXmlMoveClass"), args);
        }
        
        public void performExternalChange() {
            ProviderUtil.renameManagedClass(persistenceUnit, newName, oldName, puDataObject);
        }
        
        public void undoExternalChange() {
            ProviderUtil.renameManagedClass(persistenceUnit, oldName, newName, puDataObject);
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
    }
    
}
