/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.options.macros;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.core.options.keymap.api.ShortcutsFinder;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.NotifyDescriptor.InputLine;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;


/**
 * Implementation of one panel in Options Dialog.
 *
 * @author Jan Jancura
 */
public class MacrosPanel extends JPanel implements ActionListener, 
ListSelectionListener {
    
    private MacrosModel     model;
    private boolean         listen = true;
    private String          currentMacro;

    
    /** 
     * Creates new form MacrosPanel.
     */
    public MacrosPanel () {
        initComponents ();
        
        setName(loc ("Macro_Tab"));
        
        // 1) init components
        tMacros.getAccessibleContext ().setAccessibleName (loc ("AN_Macros_Table"));
        tMacros.getAccessibleContext ().setAccessibleDescription (loc ("AD_Macros_Table"));
        epMacroCode.getAccessibleContext ().setAccessibleName (loc ("AN_Macro"));
        epMacroCode.getAccessibleContext ().setAccessibleDescription (loc ("AD_Macro"));
        bRemove.setEnabled (false);
        bSetShortcut.setEnabled (false);
        loc (bNew, "New_Macro");
        loc (bRemove, "Remove_Macro");
        loc (bSetShortcut, "Shortcut");
        bNew.addActionListener (this);
        bRemove.addActionListener (this);
        bSetShortcut.addActionListener (this);
        tMacros.getSelectionModel ().setSelectionMode 
            (ListSelectionModel.SINGLE_SELECTION);
        tMacros.getSelectionModel ().addListSelectionListener (this);
        tMacros.getTableHeader ().setReorderingAllowed (false);
        epMacroCode.setEditorKit (JEditorPane.createEditorKitForContentType("text/plain"));
        loc (lMacros, "Macro_List");
        lMacros.setLabelFor (tMacros);
        loc (lMacroCode, "Macro_Code");
        lMacroCode.setLabelFor (epMacroCode);
    }
    
    
    // UI form .................................................................
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        lMacros = new javax.swing.JLabel();
        spMacros = new javax.swing.JScrollPane();
        tMacros = new javax.swing.JTable();
        bNew = new javax.swing.JButton();
        bSetShortcut = new javax.swing.JButton();
        bRemove = new javax.swing.JButton();
        lMacroCode = new javax.swing.JLabel();
        sMacroCode = new javax.swing.JScrollPane();
        epMacroCode = new javax.swing.JEditorPane();

        lMacros.setText("Macros:");

        tMacros.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        spMacros.setViewportView(tMacros);

        bNew.setText("New");

        bSetShortcut.setText("Set Shortcut...");

        bRemove.setText("Remove");

        lMacroCode.setText("Macro Code:");

        sMacroCode.setViewportView(epMacroCode);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(lMacros)
                    .add(lMacroCode)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, sMacroCode, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 327, Short.MAX_VALUE)
                            .add(spMacros, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 327, Short.MAX_VALUE))
                        .add(18, 18, 18)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                            .add(bNew, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 128, Short.MAX_VALUE)
                            .add(bSetShortcut, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, bRemove, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .add(13, 13, 13)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(lMacros)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(bNew)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(bSetShortcut)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(bRemove))
                    .add(spMacros, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 113, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(lMacroCode)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(sMacroCode, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 147, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton bNew;
    private javax.swing.JButton bRemove;
    private javax.swing.JButton bSetShortcut;
    private javax.swing.JEditorPane epMacroCode;
    private javax.swing.JLabel lMacroCode;
    private javax.swing.JLabel lMacros;
    private javax.swing.JScrollPane sMacroCode;
    private javax.swing.JScrollPane spMacros;
    private javax.swing.JTable tMacros;
    // End of variables declaration//GEN-END:variables
    
    
    private static String loc (String key) {
        return NbBundle.getMessage (MacrosPanel.class, key);
    }
    
    private static void loc (Component c, String key) {
        if (!(c instanceof JLabel)) {
            c.getAccessibleContext ().setAccessibleName (loc ("AN_" + key));
            c.getAccessibleContext ().setAccessibleDescription (loc ("AD_" + key));
        }
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText (
                (AbstractButton) c, 
                loc ("CTL_" + key)
            );
        } else {
            Mnemonics.setLocalizedText (
                (JLabel) c, 
                loc ("CTL_" + key)
            );
        }
    }
    
    public void update () {
        model = MacrosModel.getModel(lookup);
        listen = false;
        DefaultTableModel tableModel = model.getShortcutsTableModel ();
        currentMacro = null;
        tableModel.setColumnIdentifiers (new String[] {
            loc ("Macro_Name_Title"),
            loc ("Macro_Code_Title")
        });
        tMacros.setModel (tableModel);
        listen = true;
        if (model.getMacroNames().size () > 0) 
            tMacros.getSelectionModel ().setSelectionInterval (0, 0);
    }
    
    public void applyChanges () {
        saveCurrentMacro ();
        if (model != null)
            model.applyChanges ();
    }
    
    public void cancel () {
        if (model != null)
            model.cancel ();
    }
    
    public boolean dataValid () {
        return true;
    }
    
    public boolean isChanged () {
        if (model == null) return false;
        return model.isChanged ();
    }
    
    private Lookup lookup;
    
    void setLookup (Lookup lookup) {
        this.lookup = lookup;
    }
    
    
    // ActionListener ..........................................................
    
    public void actionPerformed (ActionEvent e) {
        if (!listen) return;
        if (e.getSource () == bNew) {
            InputLine descriptor = new InputLine (
                loc ("CTL_Enter_macro_name"),
                loc ("CTL_New_macro_dialog_title")
            );
            if (DialogDisplayer.getDefault ().notify (descriptor) ==
                InputLine.OK_OPTION
            ) {
                String macroName = descriptor.getInputText ().trim ();
                if (macroName.length () == 0) {
                    DialogDisplayer.getDefault ().notify (
                        new NotifyDescriptor.Message (
                            loc ("CTL_Empty_Macro_Name"),
                            NotifyDescriptor.ERROR_MESSAGE
                        )
                    );
                } else {
                    Iterator it = model.getMacroNames ().iterator ();
                    boolean duplicate = false;
                    while (it.hasNext ()) {
                        String name = (String) it.next ();
                        if (macroName.equals (name)) {
                            DialogDisplayer.getDefault ().notify (
                                new NotifyDescriptor.Message (
                                    loc ("CTL_Duplicate_Macro_Name"),
                                    NotifyDescriptor.ERROR_MESSAGE
                                )
                            );
                            duplicate = true;
                            break;
                        }
                    }
                    if (!duplicate) {
                        listen = false;
                        model.addMacro (macroName, "");
                        listen = true;
                        tMacros.getSelectionModel ().setSelectionInterval (0, 0);
                        spMacros.getVerticalScrollBar ().setValue (0);
                    }
                }
            }
            SwingUtilities.invokeLater (new Runnable () {
                public void run () {
                    epMacroCode.requestFocus ();
                }
            });
        } else
        if (e.getSource () == bRemove) {
            int index = tMacros.getSelectedRow ();
            listen = false;
            model.removeMacro (index);
            listen = true;
            currentMacro = null;
            if (index < tMacros.getModel ().getRowCount ())
                tMacros.getSelectionModel ().setSelectionInterval 
                    (index, index);
            else
            if (tMacros.getModel ().getRowCount () > 0)
                tMacros.getSelectionModel ().setSelectionInterval (
                    tMacros.getModel ().getRowCount () - 1,
                    tMacros.getModel ().getRowCount () - 1
                );
            else {
                bRemove.setEnabled (false);
                bSetShortcut.setEnabled (false);
            }
        } else
        if (e.getSource () == bSetShortcut) {
            int index = tMacros.getSelectedRow ();
            ShortcutsFinder f = (ShortcutsFinder)lookup.lookup(ShortcutsFinder.class);
            String shortcut = f.showShortcutsDialog();
            saveCurrentMacro ();
            if (shortcut != null)
                model.setShortcut (index, shortcut);
            SwingUtilities.invokeLater (new Runnable () {
                public void run () {
                    epMacroCode.requestFocus ();
                }
            });
        }
    }
    
    public void valueChanged (ListSelectionEvent e) {
        int index = tMacros.getSelectedRow ();
        if (index < 0) {
            epMacroCode.setText ("");
            bRemove.setEnabled (false);
            bSetShortcut.setEnabled (false);
            return;
        }
        saveCurrentMacro ();
        
        bRemove.setEnabled (true);
        bSetShortcut.setEnabled (true);
        String name = getCurrentMacro ();
        String text = model.getMacroText (name);
        epMacroCode.setText (text);
        currentMacro = name;
    }

    private String getCurrentMacro () {
        int index = tMacros.getSelectedRow ();
        if (index < 0) return null;
        return (String) tMacros.getModel ().getValueAt (index, 0);
    }
    
    private void saveCurrentMacro () {
        if (currentMacro == null) return;
        if (epMacroCode.getText ().equals (model.getMacroText (currentMacro)))
            return;
        model.setMacroText (currentMacro, epMacroCode.getText ());
        firePropertyChange (OptionsPanelController.PROP_CHANGED, null, null);
    }
}
