/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.options.macros;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.api.ShortcutsFinder;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;


class MacrosModel {
    
    private ShortcutsFinder keymapModel;
    /** Map (String (macro name) > String (macro text)).*/
    private Map<String, String> macroNameToText;
    private DefaultTableModel tableModel;
    private boolean         changed = false;

    private static MacrosModel sharedModel = null;
    private static Reference<Lookup> lastLookupRef = null;
    
    public static synchronized MacrosModel getModel(Lookup lookup) {
        if (lookup == null) {
            return sharedModel;
        } else {
            Lookup lastLookup = lastLookupRef == null ? null : lastLookupRef.get();
            if (lastLookup == null || lastLookup != lookup) {
                sharedModel = null;
            }
            if (sharedModel == null) {
                sharedModel = new MacrosModel(lookup);
                lastLookupRef = new WeakReference<Lookup>(lookup);
            }
            return sharedModel;
        }
    }

    public void reset() {
        init();
    }
    
    MacrosModel (Lookup lookup) {
        keymapModel = lookup.lookup(ShortcutsFinder.class);
        init();
    }
    
    private void init () {
        // 1) init macroNameToText
        macroNameToText = new HashMap<String, String>();
        Set mimeTypes = EditorSettings.getDefault().getMimeTypes();
        for(Iterator i = mimeTypes.iterator(); i.hasNext(); ) {
            String mimeType = (String) i.next();
            BaseOptions baseOptions = MimeLookup.getLookup(MimePath.parse(mimeType)).lookup(BaseOptions.class);
            if (baseOptions != null) {
                macroNameToText.putAll(baseOptions.getMacroMap());
            }
        }
        macroNameToText.remove(null);
        
        // load shortcuts & create data for table
        Vector<Vector<String>> data = new Vector<Vector<String>>();
        for(Iterator it = macroNameToText.keySet().iterator(); it.hasNext(); ) {
            String macroName = (String) it.next ();
            String shortcut = "";
            ShortcutAction action = keymapModel.findActionForId 
                ("macro-" + macroName);
            if (action == null)
                action = keymapModel.findActionForId (macroName);
            if (action != null) {
                String[] shortcuts = keymapModel.getShortcuts (action);
                if (shortcuts.length > 0)
                    shortcut = shortcuts [0];
            }
            Vector<String> line = new Vector<String>();
            line.add (macroName);
            line.add (shortcut);
            data.add (line);
        }
        Collections.sort (data, new MComparator ());
        Vector<String> columns = new Vector<String>(2);
        columns.add (loc ("Macro_Name_Title"));
        columns.add (loc ("Macro_Code_Title"));
        tableModel = new DefaultTableModel (data, columns) {
            public @Override boolean isCellEditable (int row, int column) {
                return false;
            }
        };
        tableModel.getColumnName(2);
    }
    
    DefaultTableModel getShortcutsTableModel () {
        return tableModel;
    }
    
    boolean isChanged () {
        return changed;
    }
    
    Collection getMacroNames () {
        return Collections.unmodifiableCollection (macroNameToText.keySet ());
    }
    
    String getMacroText (String macroName) {
        return macroNameToText.get (macroName);
    }
    
    void addMacro (String macroName, String text) {
        tableModel.insertRow (0, new Object [] {macroName, text});
        macroNameToText.put (macroName, text);
    }
    
    void removeMacro (int index) {
        String macroName = (String) tableModel.getValueAt (index, 0);
        macroNameToText.remove (macroName);
        tableModel.removeRow (index);

        keymapModel.refreshActions();
        ShortcutAction actionImpl = keymapModel.findActionForId(BaseKit.macroActionPrefix + macroName);
        if (actionImpl != null) {
            keymapModel.setShortcuts(actionImpl, Collections.<String>emptySet());
        }
        changed = true;
    }
    
    void setMacroText (String macroName, String text) {
        if (macroNameToText.containsKey (macroName) && 
            text.equals (macroNameToText.get (macroName))
        ) return;
        macroNameToText.put (macroName, text);
        changed = true;
    }
    
    void setShortcut (int index, String shortcut) {
        tableModel.setValueAt (shortcut, index, 1);
//        BaseOptions baseOptions = (BaseOptions) BaseOptions.findObject 
//            (BaseOptions.class, true);
//        baseOptions.setMacroMap (new HashMap (macroNameToText));
//        BaseKit editorKit = BaseKit.getKit (ExtKit.class);
//        TextAction textAction = (TextAction) editorKit.getActionByName 
//            ("macro-" + tableModel.getValueAt (index, 0));
//        System.out.println("textAction " + textAction);
//        ShortcutAction shortcutAction = new EditorBridge.EditorAction (textAction);
        saveMacros ();
        keymapModel.refreshActions ();
        ShortcutAction shortcutAction = keymapModel.findActionForId (
            BaseKit.macroActionPrefix + tableModel.getValueAt (index, 0)
        );
        keymapModel.setShortcuts (shortcutAction, Collections.singleton (shortcut));
        changed = true;
    }

    void applyChanges () {
        saveMacros ();
        keymapModel.apply();
        changed = false;
    }
    
    void cancel () {
        init ();
        changed = false;
    }
    
    private static String loc (String key) {
        return NbBundle.getMessage (MacrosPanel.class, key);
    }
    
    private void saveMacros () {
        Set mimeTypes = EditorSettings.getDefault().getMimeTypes();
        for(Iterator i = mimeTypes.iterator(); i.hasNext(); ) {
            String mimeType = (String) i.next();
            BaseOptions baseOptions = MimeLookup.getLookup(MimePath.parse(mimeType)).lookup(BaseOptions.class);
            if (baseOptions != null) {
                baseOptions.setMacroMap(new HashMap<String, String>(macroNameToText));
            }
        }
    }
    
    
    // innerclasses ............................................................
    
    private static final class MComparator implements Comparator<Vector<String>> {
        public int compare (Vector<String> o1, Vector<String> o2) {
            String s1 = o1.get (0);
            String s2 = o2.get (0);
            return s1.compareTo (s2);
        }
    } // End of MComparator class
}
