/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: ds_ipfw.c,v 1.43 2008-02-23 08:35:02 anton Exp $ */

#ifdef FREEBSD
#include "netams.h"
#include "ds_any.h"

/////////////////////////////////////////////////////////////////////////////////////
void ds_ipfw_cancel(void *ptr);
/////////////////////////////////////////////////////////////////////////////////////
void ds_ipfw(Service_DS *ds) {
	socklen_t size_ds = sizeof(struct sockaddr_in);
        int socketid;
	FlowEngine *FE=ds->FE;
	unsigned len;
	struct timeval start;
	unsigned char *packet=ds->packet;
	
	struct sockaddr_in sin;
        sin.sin_family = AF_INET;
        sin.sin_addr.s_addr = INADDR_ANY;
        sin.sin_port = htons(ds->port);


        if ((socketid = socket(PF_INET, SOCK_RAW, IPPROTO_DIVERT)) < 0) {
		aLog(D_ERR, "divert socket\n");
		goto END;
	}
        if (bind(socketid, (struct sockaddr *)&(sin), sizeof(sin))) {
		aLog(D_ERR, "bind divert socket: %u\n", socketid);
		goto END;
	}
	SET_POLL(socketid);

	pthread_cleanup_push(ds_ipfw_cancel, (void*) &socketid);
	pthread_setcanceltype(PTHREAD_CANCEL_DEFERRED, NULL);

	aLog(D_INFO,"IPFW packet processing for data-source:%u initialized\n",ds->instance);
	
	int			status;
	int			process_result;
	struct ipv4_key		key;
	bzero(&key, sizeof(struct ipv4_key));
	entry                   *flow_entry;

	while(1) {
		CHECK_POLL(ds,status);
		
                netams_gettimeofday(&start, NULL);
		FE->Expiresearch(&start);  
		if(!status) continue;
		
		len=recvfrom(socketid, packet, MAX_PKT_SIZE, 0, (struct sockaddr *)&sin, &size_ds);
		IPv4GetKey((struct ip*) packet, &key);
		
		process_result = FE->Process((u_char *)&key, 1, ntohs(((struct ip*) packet)->ip_len), &flow_entry);
		if(process_result == -1) {
			IPv4FillFlow(&key, flow_entry);

#ifdef LAYER7_FILTER
			if (ds->layer7_detect!=LAYER7_DETECT_NONE) layer7_addinfo(key.tcp_info.dst_port, flow_entry); 
#endif

			if(ds->ds_flags==DS_DIVERT) process_result = FE->FW(flow_entry);
		}
		
		if (process_result && (ds->ds_flags==DS_DIVERT)) 
			sendto(socketid, packet, len, 0, (struct sockaddr *)&sin, size_ds);
		
#ifdef LAYER7_FILTER
		if (ds->layer7_detect!=LAYER7_DETECT_NONE) layer7_checkinfo(key.tcp_info.dst_port, flow_entry, (struct ip*) packet); 
#endif
		ds->Measure(&start, len);
	}
END:
	pthread_cleanup_pop(1);
}
/////////////////////////////////////////////////////////////////////////////////////
void ds_ipfw_cancel(void *ptr) {
	int socketid=*(int*)ptr;
	shutdown(socketid, SHUT_RDWR);
	close(socketid);
}
/////////////////////////////////////////////////////////////////////////////////////
#endif
/////////////////////////////////////////////////////////////////////////////////////
