using System.Collections.Generic;
using System;

class C : IEnumerable [int] 
{
  public GetEnumerator () : IEnumerator [int]
  {
    yield 42;
    yield 13;
    yield 77;
  }
}

[Record]
class D : IEnumerable [string] 
{
  mutable a : int;
  ene : string;
  due : string;
  static rabe : string = "trzy";

  public GetEnumerator () : IEnumerator [string]
  {
    ++a;
    do_get (a)
  }

  do_get (qux : int) : IEnumerator [string]
  {
    yield qux.ToString ();
    yield ene;
    yield this.due;
    yield rabe;
  }
}

class E : IEnumerable [int] 
{
  public GetEnumerator () : IEnumerator [int]
  {
    for (mutable i = 1; i < 5; ++i)
      yield i;
  }
}

class X {
  public static FromTo (from : int, to : int) : IEnumerable [int]
  {
    for (mutable i = from; i <= to; ++i)
      yield i;
  }
  
  public static FromTo2 (mutable from : int, to : int) : IEnumerable [int]
  {
    while (from <= to) {
      yield from;
      from++;
    }
  }
}

// #587
public class Sequence
{
        public static Concat['a] (
                 first : IEnumerable ['a],
                 second : IEnumerable ['a]) : IEnumerable ['a]
        {
                when (first == null || second == null)
                        throw ArgumentNullException ();

                foreach (element in first)
                        yield element;
                foreach (element in second)
                        yield element;
        }

    // #588
    public Foo (a : int) : System.Collections.IEnumerable
    {
        try {
            try {
                yield a;
            } finally {
                Console.WriteLine ("Hello World");
            }

            Console.WriteLine ("Next block");

            try {
                yield a * a;
            } finally {
                Console.WriteLine ("Boston");
            }
        } finally {
            Console.WriteLine ("Outer finally");
        }

        Console.WriteLine ("Outer block");
    }

        // #589
        public a () : System.Collections.IEnumerable
        {
                lock (this){
                        yield "a";
                        yield "b";
                }
        }
}

foreach (e in C ())
  System.Console.WriteLine (e);

foreach (e in C ())
  System.Console.WriteLine (e);

def d = D (3, "raz", "dwa");

foreach (e in d)
  System.Console.WriteLine (e);
  
foreach (e in d)
  System.Console.WriteLine (e);

foreach (e in E ())
  System.Console.WriteLine (e);

def x = X.FromTo (42, 47);
System.Console.WriteLine ("------------");
foreach (e in x)
  System.Console.WriteLine (e);
System.Console.WriteLine ("------------");
foreach (e in x)
  System.Console.WriteLine (e);

def x = X.FromTo2 (42, 47);
System.Console.WriteLine ("------------");
foreach (e in x)
  System.Console.WriteLine (e);
System.Console.WriteLine ("------------");
foreach (e in x)
  System.Console.WriteLine (e);
System.Console.WriteLine ("------------");

def fst = [1,2,3];
def snd = [4,5,6];
foreach (x in Sequence.Concat (fst, snd))
   Nemerle.IO.printf ("%d\n", x);

def seq = Sequence ();
def list = System.Collections.ArrayList ();
foreach (o in seq.Foo (5))
    _ = list.Add (o);

/*
BEGIN-OUTPUT
42
13
77
42
13
77
4
raz
dwa
trzy
5
raz
dwa
trzy
1
2
3
4
------------
42
43
44
45
46
47
------------
42
43
44
45
46
47
------------
42
43
44
45
46
47
------------
42
43
44
45
46
47
------------
1
2
3
4
5
6
Hello World
Next block
Boston
Outer finally
Outer block
END-OUTPUT
*/
