
enum E1
{
  | Red = 0xFF0000
  | Green = 0x00FF00
  | Blue = 0x0000FF
}

[System.Flags]
enum E2
{
  | Red = 0xFF0000
  | Green = 0x00FF00
  | Blue = 0x0000FF
}  

module M 
{
  // When span of E1 is defined as 3 (number of named constants) in
  // DecisionTreeBuilder.n then the decision tree generated for foo
  // doesn't contain Decision.Failure node. Then foo(E1.Red | E1.Blue)
  // returns ``Blue'' instead of throwing MatchFailureException. 
  foo (e : E1) : string
  {
    try {
      match (e) { // OK
        | Red => "Red"
        | Green => "Green"
        | Blue => "Blue"
      }
    } catch {
      | _ is MatchFailureException => "exception"
    }
  }
  
  // This shows why span of E1 can't be 4 (number of named constants + 1)
  // and must be infinite (or -1). Althought 4 would work for foo () here
  // it would still make Decision.Failure missing in the tree.
  voo (e : E1) : string
  {
    try {
      match (e) { // OK
        | Red => "Red"
        | Green => "Green"
        | Blue => "Blue"
        | E1.Red %| E1.Green => "Yellow"
      }
    } catch {
      | _ is MatchFailureException => "exception"
    }
  }

  // This is for comparison that we get same results for enums with and
  // without System.Flags attribute.
  goo (e : E2) : string
  {
    try {
      match (e) { // W: matching is not exhaustive
        | Red => "Red"
        | Green => "Green"
        | Blue => "Blue"
      }
    } catch {
      | _ is MatchFailureException => "exception"
    }
  }
  
  public Main () : void
  {
    match (E1.Red : E1) { // W: matching is not exhaustive, example unmatched value: Blue
      | Green => System.Console.WriteLine ("Green")
      | Red => System.Console.WriteLine ("Red")
    }
    
    System.Console.WriteLine (foo (E1.Red));
    System.Console.WriteLine (foo (E1.Blue));
    System.Console.WriteLine (foo (E1.Red | E1.Blue));

    System.Console.WriteLine (voo (E1.Green));
    System.Console.WriteLine (voo (E1.Red | E1.Green));
    System.Console.WriteLine (voo (E1.Green | E1.Blue));
    
    System.Console.WriteLine (goo (E2.Red));
    System.Console.WriteLine (goo (E2.Green));
    System.Console.WriteLine (goo (E2.Red | E2.Green));
  }
}

/*
BEGIN-OUTPUT
Red
Red
Blue
exception
Green
Yellow
exception
Red
Green
exception
END-OUTPUT
*/
 
