
variant V {
  | Keyword { name : string; }
  | SquareGroup { mutable child : V; }

  public override ToString () : string
  {
    match (this) {
      | Keyword (name) => "Keyword(" + name + ")"
      | SquareGroup (child) => "SquareGroup[" + child.ToString () + "]"
    }
  }
}

variant W {
  | Method { f_implements : list [string] }
  | Constructor
}


public module M
{
  /* Simplified version of code from Nemerle.Compiler.MainParser.ParseTopLevel ()
     that disclosed a rather subtle bug in DecisionTreeBuilder.n modified for
     new matching compiler.
     The problem was with Decision.As () generated for 'as' in second case, which
     throught Failure paths got propagated to the third case resulting in
     an invalid cast ('v' to SquareGroup before assignment) whenever 'v' was
     not a SquareGroup. */
  voo (v : V) : string
  {
    | SquareGroup (null) => "null " + v.ToString ()
    | SquareGroup as square => square.ToString ()
    | _ => "some V"
  }
 
  /* First solution to the problem described above also didn't work -- testcase
     is a simplified version of code from Nemerle.Compiler.MethodBuilder.this ()
     (ncc/hierarchy/ClassMembers.n) */
  goo (w : W, name : string) : string
  {
    | (W.Method ([]), _) when false => "1"
    | (W.Method (_ :: _ as _impl), _) => "2"
    | (_x, _) => "3"
  }
 
  public Main () : void
  {
    System.Console.WriteLine (voo (V.Keyword ("public")));
    System.Console.WriteLine (goo (W.Method ([]), "goo"));
  }
}


/*
BEGIN-OUTPUT
some V
3
END-OUTPUT
*/      
