/*
 * Copyright (c) 2003-2005 The University of Wroclaw.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *    3. The name of the University may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE UNIVERSITY BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

using Nemerle.Collections;
using Nemerle.Utility;

using Nemerle.Compiler;
using Nemerle.Compiler.Typedtree;
using Nemerle.Compiler.SolverMacros;

namespace Nemerle.Compiler
{
  public partial class MethodBuilder : MemberBuilder, IMethod
  {
    internal CreateImplementsWrapper () : void
    {
      // Message.Debug ($"check for impl wrap $this");
      // now we will create special wrappers implementing interface methods
      // when our methods are co/contra-variant (and .NET doesn't allow it automatically)
      match (fun_kind) {
        | FunKind.BoundMethod (impl_list) =>
          def is_correct_impl (impl_meth : IMethod) {

// Message.Debug ($"compare: $(current_type.GetMemType ().TypeOfMember (impl_meth))     ======     $(this.GetMemType ())");
            if (impl_meth.GetHeader ().typarms.Length == fun_header.typarms.Length &&
            declaring_type.GetMemType ().TypeOfMember (impl_meth).TryUnify (this.GetFreshType () [0]))
              true
            else {
              Util.locate (Location, MakeImplWrapper (impl_meth));
              false
            }
          }
          // we filter out interface methods, which we have implemented by means of
          // wrappers, the rest are ok to implement them directly
          def thesame = impl_list.Filter (is_correct_impl);
          this.SetFunKind (FunKind.BoundMethod (thesame));
          // Message.Debug ($"impl: $impl_list --> $thesame");
        | _ => ()
      }
    }


    MakeImplWrapper (impl_meth : IMethod) : void
    {
      // Message.Debug ($"make impl wrap $this IMPL $impl_meth");
      def hd = impl_meth.GetHeader ();
      def parms = hd.parms;
      mutable new_typarms = [];

      Util.cassert (Name.IndexOf ('.') == -1,
                    $ "impl loop, $this IMPL $impl_meth, "
                   "$(this.GetMemType()) != $(declaring_type.GetMemType ().TypeOfMember (impl_meth))");

      def subst =
          declaring_type.SubtypingSubst (impl_meth.DeclaringType);

      def orig_typarms = hd.typarms;
      //this.GetHeader ().typarms;
      unless (orig_typarms.IsEmpty) {
        def (s2, newtp) = StaticTyVar.CopyList (orig_typarms);
        //Message.Debug ($"newtp: $orig_typarms -> $newtp");
        new_typarms = newtp;
        //Message.Debug ($"subst before: $subst");
        subst.AddSubst (s2);
        List.Iter2 (fun_header.typarms, newtp, 
                    fun (tv, repl) {
                      subst.Add (tv, MType.TyVarRef (repl))
                    });
        //Message.Debug ($"subst after: $subst");
      }

      def parm_types_names =
        parms.Map (fun (parm) { (subst.Apply (parm.ty.Fix ()), Macros.NewSymbol ("sp_parm")) });
      def formal_parms =
        parm_types_names.Map (fun (ty, name) { 
          <[ parameter: $(name : name) : $(ty : typed) ]> 
        });
      def name = 
        impl_meth.DeclaringType.FullName + "." + impl_meth.Name;

      declaring_type.forced_typarms = new_typarms;
      def meth =
        declaring_type.bind_and_add_member (<[ decl:
          private $(name : dyn) (.. $formal_parms) : $(subst.Apply (hd.ret_type.Fix ()) : typed)
          {
          }
        ]>) :> MethodBuilder;
      //Message.Debug ($"added $meth");
      meth.SetFunKind (FunKind.BoundMethod ([impl_meth]));
      meth.Attributes |= NemerleAttributes.SpecialName | NemerleAttributes.Sealed;
      unless (impl_meth.DeclaringType.IsInterface) {
        meth.Attributes = NemerleAttributes.Public | NemerleAttributes.Override;
      }

      meth.disable_type_attr = true;
      meth.HasBeenUsed = true;

      def current_fun = meth.GetHeader ();
      def refs =
        current_fun.parms.Map (fun (parm : Fun_parm) {
          def val =
            LocalValue (current_fun, parm.name, parm.ty,
                        LocalValue.Kind.FunParm (ParmKind.Normal),
                        is_mutable = false);
          val.Register ();
          val.UseFrom (current_fun);
          parm.decl = val;
          TExpr.LocalRef (val.Type, val)
        });

      def casted_refs = refs.Map (Parm);
      // def ty = subst.Apply (impl_meth.GetMemType ());
      // def vars = new_typarms.Map (fun (x) { MType.TyVarRef (x) });
      def (the_method_type, vars) =
        declaring_type.GetMemType ().TypeOfMethodWithTyparms (this);
      List.Iter2 (new_typarms, vars, fun (x, tv) { 
        tv.ForceUnify (MType.TyVarRef (x)) 
      });
      def (_, ret_type) = the_method_type.Fix ().FunReturnTypeAndParms (this);
      //Message.Debug ($"ty=$ty");

      def methref =
        TExpr.MethodRef (the_method_type, TExpr.This (declaring_type.GetMemType ()),
                         this, vars, ! impl_meth.DeclaringType.IsInterface);

      // call the wrapped method, 
      def body = TExpr.Call (ret_type, methref, casted_refs, false);
      //Message.Debug ($"ty=$((this.ReturnType.Fix ()))  $(subst.Apply (this.ReturnType.Fix ()))");
      
      meth.GetHeader ().body = FunBody.Typed (body);
      meth.GetHeader ().typarms = new_typarms;

      def t4 = Typer4 (meth);
      t4.Run ();

      DeclaringType.Manager.MaybeCompile (declaring_type, meth);
    }
  }
}
