/* $Id: Pub_set.cpp 103491 2007-05-04 17:18:18Z kazimird $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'pub.asn'.
 */

// standard includes

// generated includes
#include <ncbi_pch.hpp>
#include <objects/pub/Pub_set.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CPub_set::~CPub_set(void)
{
}

// Handles looping thru list of pub, medline, article, journal, book, 
// proceeding, or patent, creating a label by concatenting labels
// for objects in the list
template <class T>
static void s_GetLabel(string* label, const list<CRef<T> >& the_list)
{
    bool first = true;
    ITERATE(typename list<CRef<T> >, it, the_list) {
        if (!first) {
            *label += ",";
        } else {
            first = false;
        }
        (*it)->GetLabel(label);
    }        
}

// Determines the type of set and calls the appropriately instantiated
// s_GetLabel
void CPub_set::GetLabel(string* label) const
{
    // Ensure label exists
    if (!label) {
        return;
    }
    
    switch (Which()) {
    case e_Pub:
        s_GetLabel<CPub>(label, GetPub());
        break;
    case e_Medline:
        s_GetLabel<CMedline_entry>(label, GetMedline());
        break;
    case e_Article:
        s_GetLabel<CCit_art>(label, GetArticle());
        break;
    case e_Journal:
        s_GetLabel<CCit_jour>(label, GetJournal());
        break;
    case e_Book:
        s_GetLabel<CCit_book>(label, GetBook());
        break;
    case e_Proc:
        s_GetLabel<CCit_proc>(label, GetProc());
        break;
    case e_Patent:
        s_GetLabel<CCit_pat>(label, GetPatent());
        break;
    default:
        break;
    }
}

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 61, chars: 1874, CRC32: 8b72a069 */
