/* nawm.h: main header */

/* Copyright (C) 1999 by the Massachusetts Institute of Technology.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in
 * advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 * M.I.T. makes no representations about the suitability of
 * this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>

enum { IGNORE_ERRORS, BEEP_ON_ERROR, SPEW_ON_ERROR };

enum { NAWM_WM_UNKNOWN, NAWM_WM_NAWM, NAWM_WM_VTWM_GAMMA };

#define NAWM_OPT_NOCAPSLOCK	(1 << 0)

#define NEGATIVE_ZERO LONG_MIN

#ifndef __GNUC__
#define __attribute__(x)
#endif

/* prototypes from bindings.c */
void initbindings(void);
int parse_mods(char **str);
KeyCode parse_key(char *key);
int parse_button(char *button);
void run(void);

/* prototypes from builtins.c */
void initbuiltins(void);

/* prototypes from keymap.c */
void initkeymap(void);
void update_keymap(void);
void *set_modifier_state(int state);
void reset_modifier_state(void *oldstate);
void typechar(KeySym ks);
#define KEYSTATE(map, kc) (map[kc >> 3] & (1 << (kc & 7)))

/* prototypes from mem.c */
void *xmalloc(size_t);
void *xrealloc(void *, size_t);
char *xstrdup(char *);

/* prototypes from nawm.c */
void do_option(char *opt);
void die(char *, ...) __attribute__ ((noreturn));
