/*
 * NASPRO - NASPRO Architecture for Sound Processing
 * Core library
 *
 * Copyright (C) 2007-2010 Stefano D'Angelo <zanga.mail@gmail.com>
 *
 * See the COPYING file for license conditions.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include <dlfcn.h>

#include <NASPRO/core/lib.h>

#include "src/dl.h"

#include "config.h"

struct _nacore_dl_module
  {
	void	*handle;
  };

static size_t dl_file_ext_len;

void
_nacore_dl_init()
{
	dl_file_ext_len = strlen(SO_FILE_EXT);
}

void
_nacore_dl_fini()
{
}

nacore_dl_module_t
nacore_dl_open(const char *file)
{
	void *handle;
	nacore_dl_module_t dl_handle;

	handle = dlopen(file, RTLD_LAZY);
	if (handle == NULL)
		return NULL;

	dl_handle = malloc(sizeof(struct _nacore_dl_module));
	if (dl_handle == NULL)
	  {
		dlclose(handle);
		return NULL;
	  }

	dl_handle->handle = handle;

	return dl_handle;
}

void *
nacore_dl_sym(nacore_dl_module_t handle, const char *symbol)
{
	void *sym;
	char *error;
	
	dlerror();	/* Clear any existing error */
	*(void **)(&sym) = dlsym(handle->handle, symbol);
	error = dlerror();
	if (error != NULL)
		return NULL;

	return sym;
}

void
nacore_dl_close(nacore_dl_module_t handle)
{
	dlclose(handle->handle);
	free(handle);
}

char
nacore_dl_filename_filter(const char *file)
{
	size_t file_len;

	file_len = strlen(file);

	if (file_len <= dl_file_ext_len)
		return 0;

	return !strcmp(file + file_len - dl_file_ext_len, SO_FILE_EXT);
}
