--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Ada.Strings.Unbounded;

with Exception_Message;
with Ok_Message;

with McKae.XML.EZ_Out.String_Stream;

package body Echo_Command is

   use Ada.Strings.Unbounded;

   --------------
   -- Set_Echo --
   --------------

   function Set_Echo (Shell_Line : String) return String is
   begin
      begin
         declare
            Arguments : constant Shell_Commands.Arguments_Array :=
              Shell_Commands.Arguments (Shell_Line);
         begin
            if Arguments'Length = 1 then
               Echo := Echo_Value'Value (To_String (Arguments (1)));
               return Ok_Message ("echo", "");
            else
               return Syntax_String;
            end if;
         end;
      exception
         when Shell_Commands.No_Argument =>
            return
              "<result cmd=""echo"" status=""OK""><name>echo</name><data>" &
              Echo'Img & "</data></result>";
      end;
   exception
      when E : others =>
         return Exception_Message ("set_echo", E);
   end Set_Echo;

   function Syntax_String
     (Status : Shell_Commands.Status_Type := Shell_Commands.Syntax_Error)
     return String is
      use McKae.XML.EZ_Out.String_Stream.String_Buffering;
      use McKae.XML.EZ_Out.String_Stream.XML_String_Buffer;
      Xml_Buffer : String_Buffer;
   begin
      Clear (Xml_Buffer);
      Start_Element (Xml_Buffer, "result",
                     ("cmd" = "echo", "status" = Status'Img));
      Start_Element (Xml_Buffer, "message", "type" = "help");
      Output_Element (Xml_Buffer, "syntax", "echo {on|off}");
      End_Element (Xml_Buffer, "message");
      End_Element (Xml_Buffer, "result");
      declare
         String_To_Return : constant String := Get_String (Xml_Buffer);
      begin
         Full_Clear (Xml_Buffer);
         return String_To_Return;
      end;
   end Syntax_String;

end Echo_Command;
