--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Ada.Strings.Unbounded;
with Ada.Containers.Vectors;

with Narval.Configurator.Abstract_Actors_Coordination;

package Narval.Partitions is

   use Configurator.Abstract_Actors_Coordination;

   type Partition_Type is record
      Name : Ada.Strings.Unbounded.Unbounded_String :=
        Ada.Strings.Unbounded.Null_Unbounded_String;
      Configuration_Hook : Configuration_Access := null;
      Host_Name : Ada.Strings.Unbounded.Unbounded_String :=
        Ada.Strings.Unbounded.Null_Unbounded_String;
   end record;

   package Partition_Vector_Package is new Ada.Containers.Vectors (Positive,
                                                             Partition_Type);

   protected type Partition_Shell_Type is
      procedure Add
        (Name : String;
         Config : Configuration_Access;
         Host_Name : String);
      function Exist (Name : String) return Boolean;
      procedure Remove (Name : String);
      function Name_All_Partitions return String;
      function Number_Of_Partitions return Natural;
      function Configuration (Name : String) return Configuration_Access;
      procedure Trig_Event (Event : String);
   private
      Partitions : Partition_Vector_Package.Vector;
   end Partition_Shell_Type;
   type Partition_Shell_Access is access all Partition_Shell_Type;

   No_Sub_System_Available : exception;

end Narval.Partitions;
