--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
------------------------------------------------------------------------------
--                                  Log4Ada                                 --
--                                                                          --
--                            Copyright (C) 2007                            --
--                              X. Grave CNRS                               --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --

with Log4ada.Events;

with Appenders; use Appenders;

package body Events_Receivers.Tcp_Socket is

   ----------------
   -- Send_Event --
   ----------------

   procedure Send_Event
     (Events_Receiver : not null access Events_TCP_Socket_Type;
      Event : String;
      Event_Type : Supported_Events_Type := Log4ada_Event)
   is
      Local_Event : Log4ada.Events.Event_Type;
   begin
      if Event_Type /= Log4ada_Event then
         raise Event_Type_Not_Supported;
      end if;
      Local_Event := Log4ada.Events.To_Event (Event);
      Log4ada.Loggers.Event_Out (Events_Receiver.Logger'Access, Local_Event);
   end Send_Event;

   procedure Initialise (Receiver : in out Events_TCP_Socket_Type;
                         Level : Log4ada.Level_Type) is
   begin
      Log4ada.Loggers.Set_Name
        (Receiver.Logger'Access,
         Ada.Strings.Unbounded.To_String (Receiver.Name));
      Log4ada.Loggers.Set_Level (Receiver.Logger'Access, Level);
      Appenders_Xml_Socket.Set_Logger (Receiver.Socket'Unchecked_Access,
                                       Receiver.Logger'Unchecked_Access);
      Log4ada.Socket_Utilities.Open_Server_Link
        (Ada.Strings.Unbounded.To_String (Receiver.Server),
         GNAT.Sockets.Port_Type (Receiver.Port));
      Log4ada.Loggers.Add_Appender (Receiver.Logger'Access,
                                    Receiver.Socket'Unchecked_Access);
      if Receiver.Console then
         Log4ada.Loggers.Add_Appender (Receiver.Logger'Access,
                                       Console'Access);
      end if;
      Log4ada.Loggers.Info_Out (Receiver.Logger'Access,
                                Ada.Strings.Unbounded.To_String (Receiver.Name)
                                & " is started.");
   end Initialise;

end Events_Receivers.Tcp_Socket;
