--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------

--  wsdl2aws SOAP Generator v2.0
--
--  AWS 2.2.0 - SOAP 1.4.0
--  This file was generated on Wednesday 06 February 2008 at 10:05:06
--
--  $ wsdl2aws -spec narval_aws_interface -f
--  -main aws_interface_main -cb narval_aws.wsdl

with Ada.Exceptions;

with SOAP.Message.Response.Error;

with narval_aws_interface;

with narval_aws_Service.Server;
with narval_aws_Service.Types;

package body narval_aws_Service.CB is

   use Ada.Exceptions;

   pragma Warnings (Off, narval_aws_Service.Server);
   pragma Warnings (Off, narval_aws_Service.Types);

   pragma Style_Checks (Off);

   function Send_Command_CB is
     new narval_aws_Service.Server.Send_Command_CB (narval_aws_interface.Send_Command);

   function Send_Command_With_Arguments_CB is
     new narval_aws_Service.Server.Send_Command_With_Arguments_CB (narval_aws_interface.Send_Command_With_Arguments);

   -------------
   -- SOAP_CB --
   -------------

   function SOAP_CB
     (SOAPAction : in String;
      Payload    : in Message.Payload.Object;
      Request    : in AWS.Status.Data)
      return Response.Data is
   begin
      if SOAPAction = "Send_Command" then
         return Send_Command_CB (SOAPAction, Payload, Request);

      elsif SOAPAction = "Send_Command_With_Arguments" then
         return Send_Command_With_Arguments_CB (SOAPAction, Payload, Request);

      else
         return Message.Response.Build
           (Message.Response.Error.Build
             (Message.Response.Error.Client,
              "Wrong SOAP action " & SOAPAction));
      end if;
   exception
      when E : others =>
         return Message.Response.Build
           (Message.Response.Error.Build
             (Message.Response.Error.Client,
              "Error in SOAP_CB for SOAPAction " & SOAPAction
                & " (" & Exception_Information (E) & ")"));
   end SOAP_CB;

end narval_aws_Service.CB;
