#include <stdlib.h>
#include <stdio.h>
#include "parameters.h"

extern int test_function_to_be_called (void);

static int next_id = 0;
struct my_struct
{
  int id;
  int some_algo_dependent_data;
};

/* you must have the following symbols */
/* see John Cresswell document for details : */
/* AGATA PSA and Tracking Algorithm Integration*/
void process_config (char *directory_path, unsigned int *error_code);
struct my_struct *process_register (unsigned int *error_code);
/* the call of this routine is different from the one in the document */
/* because document discribe filter interface and here we produce data */
/* you should always return something in thee output buffer and */
/* used_size_of_output_buffer have to be non zero in old narval version */
/* ask X. Grave grave@ipno.in2p3.fr for more details */
void process_block (struct my_struct *algo_data,
		    void *output_buffer,
		    unsigned int size_of_output_buffer,
		    unsigned int *used_size_of_output_buffer,
		    unsigned int *error_code);
/* optionnal symbols */
/* this symbol isn't documented for the moment, it should contain 0 or the */
/* maximum size of one event, value 0 is safe */
int max_size = 0;
void process_initialise (struct my_struct *algo_data,
			 unsigned int *error_code);
void process_reset (struct my_struct *algo_data,
		    unsigned int *error_code);
void process_start (struct my_struct *algo_data,
		    unsigned int *error_code);
void process_stop (struct my_struct *algo_data,
		   unsigned int *error_code);
void process_pause (struct my_struct *algo_data,
		    unsigned int *error_code);
void process_resume (struct my_struct *algo_data,
		     unsigned int *error_code);
void process_unload (struct my_struct *algo_data,
		     unsigned int *error_code);

/* coding region */

void process_config (char *directory_path, unsigned int *error_code)
{
  printf ("call to process_config\n");
  printf ("directory path = %s\n",directory_path);
  *error_code = 0;
}

struct my_struct *process_register (unsigned int *error_code)
{
  struct my_struct *algo_data;
  int loc_error_code;

  printf ("here is the answer : %d\n", test_function_to_be_called ());

  algo_data = (struct my_struct *) malloc (sizeof (struct my_struct));
  algo_data->id = next_id;
  next_id++;
  algo_data->some_algo_dependent_data = 0;
  ada_add_new_parameter ("c_param;boolean_type;read_write;true",
			 &loc_error_code);
  if (loc_error_code != 0)
    {
      printf ("error in ada_add_new_parameter\n");
    }
  ada_add_new_parameter ("c_param2;integer_type;read_write;0",
			 &loc_error_code);
  if (loc_error_code != 0)
    {
      printf ("error in ada_add_new_parameter\n");
    }
  return algo_data;
}

void process_block (struct my_struct *algo_data,
		    void *output_buffer,
		    unsigned int size_of_output_buffer,
		    unsigned int *used_size_of_output_buffer,
		    unsigned int *error_code)
{
  unsigned int size_of_output_buffer_in_32_bits_word;
  unsigned int *data;
  unsigned int i;
  int loc_error_code;
  char buffer[20];
  int param;

  size_of_output_buffer_in_32_bits_word = size_of_output_buffer / 4;
  data = (unsigned int *) output_buffer;
  data [0] = algo_data->some_algo_dependent_data;
  for (i=1;i<size_of_output_buffer_in_32_bits_word;i++)
    {
      data [i] = i;
    }
  algo_data->some_algo_dependent_data++;
  ada_get_parameter ("c_param2", buffer, 20, &loc_error_code);
  if (loc_error_code != 0)
    {
      printf ("error in ada_get_parameter\n");
    }
  param = atoi (buffer);
  param += 2;
  sprintf (buffer, "%d", param);
  ada_set_parameter ("c_param2", buffer, &loc_error_code);
  if (loc_error_code != 0)
    {
      printf ("error in ada_set_parameter\n");
    }
  *error_code = 0;
  *used_size_of_output_buffer = size_of_output_buffer_in_32_bits_word * 4;
}

void process_initialise (struct my_struct *algo_data,
			 unsigned int *error_code)
{
  printf ("process_initialise called with id=%d\n",algo_data->id);
  /* put your code here */
  *error_code = 0;
}
void process_reset (struct my_struct *algo_data,
		    unsigned int *error_code)
{
  printf ("process_reset called with id=%d\n",algo_data->id);
  /* put your code here */
  *error_code = 0;
}
void process_start (struct my_struct *algo_data,
		    unsigned int *error_code)
{
  printf ("process_start called with id=%d\n",algo_data->id);
  /* put your code here */
  *error_code = 0;
}
void process_stop (struct my_struct *algo_data,
		   unsigned int *error_code)
{
  printf ("process_stop called with id=%d\n",algo_data->id);
  /* put your code here */
  *error_code = 0;
}
void process_pause (struct my_struct *algo_data,
		    unsigned int *error_code)
{
  printf ("process_pause called with id=%d\n",algo_data->id);
  /* put your code here */
  *error_code = 0;
}
void process_resume (struct my_struct *algo_data,
		     unsigned int *error_code)
{
  printf ("process_resume called with id=%d\n",algo_data->id);
  /* put your code here */
  *error_code = 0;
}
void process_unload (struct my_struct *algo_data,
		     unsigned int *error_code)
{
  printf ("process_unload called with id=%d\n",algo_data->id);
  /* put your code here */
  free (algo_data);
  *error_code = 0;
}
