#ifndef _NAP_SCHECK_H
#define _NAP_SCHECK_H

/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

#include <ncurses.h>
#include "cmds.h"  
#include "library.h"
      
/* the following struct holds the state of a "bandwidth observer". The
   semantics of the fields is as follows: bandwidth is the most recent
   bandwidth limit in kbytes/s, or 0 if the limit is infinite. If
   bandwidth!=0, then time0 represents an arbitrary time origin (in
   seconds since the epoch), and bytes represents a byte count, such
   that the earliest time the next packet should be sent or received
   is (time0 + bytes/bandwidth/1000). */

struct bandwidth_s {
  int bandwidth;
  long time0;
  int bytes;
};
typedef struct bandwidth_s bandwidth_t;

/* bandwidth observers for global uploads and global downloads */
extern bandwidth_t bwup, bwdown;

/* used to mark a sock_t connection as "read" or "write". Note: a
   read/write connection can be marked S_R if we are waiting for the
   other end to talk to us first (such as the server connection). S_W
   is currently only used for uploads. */

#define S_R 0x1
#define S_W 0x2

/* The connection list is one of the two "backbone" data structures of
   nap (the other is the task list, of type upload_t or download_t,
   see cmds.h). */

struct sock_s 
{
  char *socknm; /* allocated */ /* name of this connection, e.g. "server" */
  unsigned char t;          /* S_R or S_W: wait for read or write? */
  int fd;                   /* file descriptor of this connection */
  FILE *f;                  /* only "icmp" and "icmperr" connections
                               have this */

  struct download_s *dtask; /* only used for download connections */
  struct upload_s *utask;   /* only used for upload connections */
  struct outbrowse_s *btask; /* only used for outgoing browse connections */ 
  char *dxx;                /* only used for irc connections */

  library_t *shared_to_send; /* list of shared files scheduled to be sent;
			      only if socknm = "server". */

  int bwlimit;              /* is bandwidth limiting requested? */
  bandwidth_t bw;           /* bandwidth observer (only used if bwlimit!=0) */

  int (*func)(WINDOW *, struct sock_s *);  /* event handler, e.g. in event.c */

  struct sock_s *next; 
};
typedef struct sock_s sock_t;

sock_t *addsock(int, char *, unsigned char, int (*)(WINDOW *, sock_t *));
void delsock(int);
sock_t *findsock(const char *);
sock_t *findsockfd(int fd);
void psocks(WINDOW *);
void bandwidth_register(bandwidth_t *bw, int n);
void bandwidth_init(bandwidth_t *bw);
long bandwidth_waittime(bandwidth_t *bw, int curbw, struct timeval *tp);
void sockfunc(WINDOW *, WINDOW *);

#endif

