/*
 * Decompiled with CFR 0.152.
 */
package org.helios.jmx.dynamic;

import java.lang.reflect.Method;
import org.helios.jmx.dynamic.annotations.JMXAttribute;
import org.helios.jmx.dynamic.annotations.options.AttributeMutabilityOption;

public class AccessorPair {
    protected String attributeName = null;
    protected Method setter = null;
    protected Method getter = null;
    protected AttributeMutabilityOption mutability = AttributeMutabilityOption.READ_WRITE;
    protected JMXAttribute getterAttribute = null;
    protected JMXAttribute setterAttribute = null;
    protected Object targetObject = null;
    public static Class[] NO_SIG = new Class[0];
    public static Object[] NO_ARGS = new Object[0];

    public AccessorPair(String attributeName, Object targetObject) {
        this.attributeName = attributeName;
        this.targetObject = targetObject;
    }

    public AccessorPair(String attributeName, Method setter, Method getter, Object targetObject) {
        this.attributeName = attributeName;
        this.setter = setter;
        this.getter = getter;
        this.targetObject = targetObject;
    }

    public String getAttributeName() {
        return this.getAttrName(this.getterAttribute, this.setterAttribute);
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public Method getSetter() {
        return this.setter;
    }

    public void setSetter(Method setter) {
        this.setter = setter;
        this.setterAttribute = setter.getAnnotation(JMXAttribute.class);
    }

    public Method getGetter() {
        return this.getter;
    }

    public void setGetter(Method getter) {
        this.getter = getter;
        this.getterAttribute = getter.getAnnotation(JMXAttribute.class);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributeName == null ? 0 : this.attributeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessorPair other = (AccessorPair)obj;
        return !(this.attributeName == null ? other.attributeName != null : !this.attributeName.equals(other.attributeName));
    }

    public AttributeMutabilityOption getMutability() {
        return this.mutability;
    }

    public void setMutability(AttributeMutabilityOption mutability) {
        this.mutability = mutability;
    }

    public String getDescription() {
        String getterDescription;
        String setterDescription = this.setterAttribute == null ? null : this.getAttrDescription(this.setterAttribute);
        String string = getterDescription = this.getterAttribute == null ? null : this.getAttrDescription(this.getterAttribute);
        if (setterDescription == null && getterDescription == null) {
            return "MBean Attribute";
        }
        if (getterDescription.equals(setterDescription)) {
            return getterDescription;
        }
        if (getterDescription != null && setterDescription == null) {
            return getterDescription;
        }
        if (setterDescription != null && getterDescription == null) {
            return setterDescription;
        }
        if (getterDescription.equals("MBean Attribute")) {
            return setterDescription;
        }
        return getterDescription;
    }

    protected String getAttrDescription(JMXAttribute attr) {
        if (attr.introspectDescription()) {
            try {
                return this.targetObject.getClass().getMethod(attr.description(), NO_SIG).invoke(this.targetObject, NO_ARGS).toString();
            }
            catch (Exception e) {
                return "MBean Attribute";
            }
        }
        return attr.description();
    }

    protected String getAttrName(JMXAttribute attr) {
        if (attr.introspectName()) {
            try {
                return this.targetObject.getClass().getMethod(attr.name(), NO_SIG).invoke(this.targetObject, NO_ARGS).toString();
            }
            catch (Exception e) {
                return attr.name();
            }
        }
        return attr.name();
    }

    protected String getAttrName(JMXAttribute getter, JMXAttribute setter) {
        if (setter == null && getter == null) {
            return "Error. No Attr Name Determined";
        }
        if (getter != null) {
            return this.getAttrName(getter);
        }
        return this.getAttrName(setter);
    }

    public JMXAttribute getGetterAttribute() {
        return this.getterAttribute;
    }

    public JMXAttribute getSetterAttribute() {
        return this.setterAttribute;
    }

    public String toString() {
        String TAB = "    ";
        StringBuilder retValue = new StringBuilder();
        retValue.append("AccessorPair ( ").append(super.toString()).append("    ").append("attributeName = ").append(this.attributeName).append("    ").append("setter = ").append(this.setter).append("    ").append("getter = ").append(this.getter).append("    ").append(" )");
        return retValue.toString();
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public void setTargetObject(Object targetObject) {
        this.targetObject = targetObject;
    }
}

