## -*- coding: utf-8 -*-
#
# «restrcited_drivers» - MCC Restricted Drivers launcher plugin
#
# Copyright (C) 2009, Mario Limonciello, for Mythbuntu
#
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##################################################################################

from MythbuntuControlCentre.plugin import MCCPlugin
import os

class RestrictedDriversPlugin(MCCPlugin):
    """A plugin for launching tools related to proprietary drivers"""

    def __init__(self):
        #Initialize parent class
        information = {}
        information["name"] = "Graphics Drivers"
        information["icon"] = "jockey"
        information["ui"] = "tab_graphics_drivers"
        MCCPlugin.__init__(self,information)

    def captureState(self):
        """Determines the state of the items on managed by this plugin
           and stores it into the plugin's own internal structures"""
        self.en_nvidia=os.path.exists('/usr/bin/nvidia-settings')
        self.en_amd=os.path.exists('/usr/bin/amdcccle')

    def applyStateToGUI(self):
        """Takes the current state information and sets the GUI
           for this plugin"""
        #Load the detected dictionary
        self.nvidia_vbox.set_sensitive(self.en_nvidia)
        self.amd_vbox.set_sensitive(self.en_amd)

    def compareState(self):
        """Determines what items have been modified on this plugin"""
        return

    #Callbacks
    def launch_app(self,widget):
        """Launches an external application"""
        if widget is not None:
            if widget.get_name() == "restricted_drivers_button":
                MCCPlugin.launch_app(self,widget,"jockey-gtk")
            elif widget.get_name() == "nvidia_settings_button":
                MCCPlugin.launch_app(self,widget,"nvidia-settings")
            elif widget.get_name() == "amdcccle_button":
                MCCPlugin.launch_app(self,widget,"amdcccle")
