#!/usr/bin/env python
## -*- coding: utf-8 -*-
#
#
# Copyright (C) 2011, Thomas Mashos, for Mythbuntu
#
#
# Mythbuntu-bare is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##################################################################################

import pycurl
import sys
import logging

logger = logging.getLogger('mythbuntu-bare')
hdlr = logging.FileHandler('/var/log/mythbuntu-bare-client.log')
formatter = logging.Formatter('%(asctime)s %(levelname)s %(message)s')
hdlr.setFormatter(formatter)
logger.addHandler(hdlr) 
logger.setLevel(logging.WARNING)

ACTOR="<push_file> "

# Check commandline arguments
if len(sys.argv) < 3:
    print "Usage: %s <url> <file to upload>" % sys.argv[0]
    raise SystemExit
url = sys.argv[1]
filename = sys.argv[2]
 
c = pycurl.Curl()
 
values = [
     ("filename", (pycurl.FORM_FILE, filename))
]

logger.info(ACTOR+'Pushing '+str(filename)+'to'+str(url))

c.setopt(c.URL, url)
c.setopt(c.HTTPPOST, values)
c.perform()
logger.info(ACTOR+'Return code: '+str(c.getinfo(pycurl.HTTP_CODE))+" from "+str(c.getinfo(pycurl.EFFECTIVE_URL)))
c.close()
