#ifndef _WB_HISTORY_TREE_H_
#define _WB_HISTORY_TREE_H_

#include "grt/tree_model.h"
#include <grtpp_undo_manager.h>

namespace wb {
  class WBContext;

  class HistoryTreeBE : public bec::TreeModel
  {
    grt::UndoManager *_undom;
    WBContext *_wb;
    int _old_row_count;

    virtual bec::NodeId get_child(const bec::NodeId &parent, int index);

    grt::ValueRef activate_node_grt(grt::GRT *grt, const bec::NodeId &node);

    virtual bec::MenuItemList get_popup_items_for_nodes(const std::vector<bec::NodeId> &nodes);
    virtual bool activate_popup_item_for_nodes(const std::string &name, const std::vector<bec::NodeId>& nodes);

    void handle_redo(grt::UndoAction*);
    void handle_undo(grt::UndoAction*);
    void handle_change();
    
  public:
    enum Column 
    {
      Description,
      Type
    };

    HistoryTreeBE(WBContext *wb, grt::UndoManager *undom);

    virtual void refresh();

    virtual bool activate_node(const bec::NodeId &node);
    virtual int count_children(const bec::NodeId &parent);
    virtual bool get_field(const bec::NodeId &node, int column, std::string &value);
  };
};


#endif
