#include <qlistview.h>
#include <qdatetime.h>
#include <qpixmap.h>
#include "schema.h"
#include "table.xpm"
#include "field.xpm"
#include "collapse.xpm"
#include "expand.xpm"
#include "schemalistviewitem.h"
#include "mainwindow.h"
#include "loglistviewitem.h"
#include "include/sql.h"

Schema::Schema(MYSQL *mysql, const QString &host, const QString &user, QWidget *widget, const char *name)
	: QListView(widget, name)
{
	addColumn("tree");  
	addColumn("z");  
	setRootIsDecorated(TRUE);

	((QWidget *)(header()))->hide();

	this->mysql = mysql;
	this->host = host;
	this->user = user;

	setColumnAlignment(1, Qt::AlignCenter);
	//setAllColumnsShowFocus(TRUE);

	setSorting(-1);

	user_flag = FLAG_COLLAPSE;

	connect(this, SIGNAL(expanded(QListViewItem *)), this, SLOT(slot_expand(QListViewItem *)));
	connect(this, SIGNAL(collapsed(QListViewItem *)), this, SLOT(slot_collapse(QListViewItem *)));
	connect(this, SIGNAL(mouseButtonPressed(int, QListViewItem *, const QPoint &, int)), this, SLOT(slot_pressed(int, QListViewItem *, const QPoint &, int)));
}

Schema::~Schema()
{
}

void Schema::set_table(QListViewItem *database)
{
	MYSQL_RES *result;	
	MYSQL_ROW row;

	SchemaListViewItem *table;	

	if(mysql_select_db(mysql,database->text(0).latin1()))
		return;

	result = mysql_list_tables(mysql,NULL);

	if(result == NULL)
		return;
	
	table = NULL;

	 SchemaListViewItem *z = new SchemaListViewItem((SchemaListViewItem *)database, NULL, "Table", FLAG_TABLE_ROOT, database->text(0));
	z->setOpen(TRUE);

	while((row = mysql_fetch_row(result)))
	{
		table = new SchemaListViewItem((SchemaListViewItem *)z, table, row[0], FLAG_TABLE, database->text(0));
		table->setPixmap(0, QPixmap(table_xpm));	

		QMap<QString, struct table_value> s = table_map.find(database->text(0)).data();
		if(s.find(row[0]) != s.end())
		{
			table->setText(1, "-");
			//table->setText(1, QChar(0x91, 0x21));
			//table->setPixmap(1, QPixmap(collapse_xpm));
			set_field(table);
		}
	}

	mysql_free_result(result);
}

void Schema::set_field(QListViewItem *table)
{
	MYSQL_RES *result;
	MYSQL_FIELD *field;

	SchemaListViewItem *z;

	result = mysql_list_fields(mysql,table->text(0).latin1(),NULL);

	if(result == NULL)
		return;
	
	z = NULL;
	SchemaListViewItem *data = new SchemaListViewItem((SchemaListViewItem *)table, z, "Field", FLAG_FIELD_ROOT, ((SchemaListViewItem *)table)->database, ((SchemaListViewItem *)table)->table);
	data->setOpen(TRUE);

	while((field = mysql_fetch_field(result)))
	{
		z = new SchemaListViewItem(data, z, field->name, FLAG_FIELD, ((SchemaListViewItem *)table)->database, table->text(0));
		z->setPixmap(0, QPixmap(field_xpm));	
	}

	QMap<QString, struct table_value> s = table_map.find(((SchemaListViewItem *)table)->database).data();
	if(s.find(table->text(0)).data().value == FLAG_EXPAND)
		table->setOpen(TRUE);
	else if(s.find(table->text(0)).data().value == FLAG_COLLAPSE)
		table->setOpen(FALSE);
	
	mysql_free_result(result);

	z = NULL;
	data = new SchemaListViewItem((SchemaListViewItem *)table, z, "Key", FLAG_KEY_ROOT, ((SchemaListViewItem *)table)->database, ((SchemaListViewItem *)table)->table);
	data->setOpen(TRUE);

	QMap<QString, bool> key;
	QMap<QString, bool>::Iterator s_;
	QString sql = "show keys from " + table->text(0);

	if(SQL::sql_query(sql.latin1()))
	{
	}
	else
	{
		result = mysql_store_result(mysql);

		if(result == NULL)
			return;

		while(MYSQL_ROW row = mysql_fetch_row(result))
			key.replace(row[2], TRUE);

		for(s_ = key.begin(); s_ != key.end(); s_++)
			z = new SchemaListViewItem(data, z, s_.key(), FLAG_KEY, ((SchemaListViewItem *)table)->database, table->text(0));
	}
}
