#include "option.h"

#include <qfiledialog.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qpushbutton.h>
#include <qlineedit.h>

void Option::slot_fire()
{
	slot_apply();

	parentWidget()->close();
}

void Option::slot_apply()
{
	option->schema = schema->isChecked();
	option->password = password->isChecked();
	option->exit = exit->isChecked();
	option->xpm = xpm->text();
	option->from = from->currentText().toInt();
	option->to = to->currentText().toInt();
	option->clear = !query->isChecked();
	option->save = save->isChecked();
	option->log = log->isChecked();

	emit signal_xpm();
}


void Option::slot_close()
{
	parentWidget()->close();
}

void Option::slot_xpm()
{
	QString s = QFileDialog::getOpenFileName(QString::null, "*.xpm; *.png", this);

	if(!s.isEmpty())
	{
		xpm->setText(s);
	}
}
