#include <qcombobox.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qlistview.h>
#include <qmessagebox.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qheader.h>
#include <qspinbox.h>
#include <string.h>
#include "find.h"
#include "mainwindow.h"
#include "include/sql.h"

void Find::slot_fire()
{
	value = max_match->text().toInt();

	total = 0;

	if(text->text().length() == 0)
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), tr("Please enter text you will find."));
		return;
	}

	query = new MDIWindow(parentWidget()->parentWidget()->parentWidget());
	sql = new QueryListView(NULL, query->statusBar(), mysql, NULL, query);
	sql->setAllColumnsShowFocus(TRUE);	
	query->setCentralWidget(sql);

	QPopupMenu *z = new QPopupMenu();
	z->insertItem(tr("&Save"), sql, SLOT(slot_save()));
	z->insertSeparator();
	z->insertItem(tr("Cl&ose"), sql, SLOT(slot_close()));
	query->menuBar()->insertItem(tr("&File"), z);

	//z = new QPopupMenu();
	//z->insertItem(tr("&About..."), sql, SLOT(slot_about()), Key_F1);
	//query->menuBar()->insertItem(tr("&Help"), z);

	sql->set_sql(database->currentText(), QString("Find - ") + QString(text->text().local8Bit()) + QString(" from ") + table->currentText() + QString(".") + database->currentText(), "");

 	sql->addColumn(tr("Database"));
 	sql->addColumn(tr("Table"));
 	sql->addColumn(tr("Field"));
 	sql->addColumn(tr("Data"));

	MYSQL_RES *result;
	MYSQL_ROW row;
	
	if(database->currentText() == "*")
	{
		result = mysql_list_dbs(mysql, NULL);

		if(result == NULL)
			return;

		while((row = mysql_fetch_row(result)))
		{
			if(slot_find(row[0]) == FALSE)
				break;
		}
	
		mysql_free_result(result);
	}
	else
	{
		slot_find(database->currentText());
	}

	query->resize(350, 200);

	query->setCaption(QString("Find - ") + QString::fromLocal8Bit(text->text().local8Bit()) + QString(" from ") + table->currentText() + QString(".") + database->currentText());

	query->show();
}

void Find::slot_close()
{
	parentWidget()->close();
}

void Find::slot_database()
{
	QList<QString> value;
	value = ((MainWindow *)qApp->mainWidget())->database->get_value();

	database->slot_value(value);

	slot_table();
}

void Find::slot_table()
{
	MYSQL_RES *result;
	MYSQL_ROW row;

	QString database;

	table->clear();
	table->insertItem("*");

	database = this->database->currentText();

	if(database[0] == '*')
		return;

	if(mysql_select_db(mysql, database.latin1()))
	{
		return;
	}

	result = mysql_list_tables(mysql, NULL);
	
	if(result == NULL)
	{
		return;
	}

	while((row = mysql_fetch_row(result)))
	{
		table->insertItem(row[0]);
	}

	mysql_free_result(result);
}

bool Find::slot_find(const QString &database, const QString &table)
{
	MYSQL_RES *result;
	MYSQL_ROW row;
	
	if(mysql_select_db(mysql, database))
		return FALSE;

	if(SQL::sql_query(QString(QString("select * from ") + table).latin1()))
		return FALSE;
	
	result = mysql_store_result(mysql);

	if(result == NULL)
		return FALSE;

	int field = mysql_num_fields(result);

	while((row = mysql_fetch_row(result)))
	{
		for(int l = 0; l < field; l++)
		{
			if(match_whole->isChecked())
			{
				if(match_case->isChecked())
				{
					if(strncmp(row[l], text->text().local8Bit().data(), strlen(text->text().local8Bit().data())) == 0)
					{
						MultiLineListViewItem *x = new MultiLineListViewItem(sql);
						x->setText(0, database);
						x->setText(1, table);
						mysql_field_seek(result, l);
						MYSQL_FIELD *f  = mysql_fetch_field(result);	
						x->setText(2, f->name);
						x->setText(3, QString::fromLocal8Bit(row[l]));
						x->slot_row_height(x);
						
						total++;
						if(value == total)
						{
							mysql_free_result(result);
							return FALSE;
						}
						//debug(row[l]);
					}
				}
				else
				{
					if(strncmp(QString(row[l]).lower().latin1(), 
							   QString(text->text().local8Bit().data()).lower().latin1(), strlen(QString(text->text().local8Bit().data()).lower().latin1())) == 0)
					{
						MultiLineListViewItem *x = new MultiLineListViewItem(sql);
						x->setText(0, database);
						x->setText(1, table);
						mysql_field_seek(result, l);
						MYSQL_FIELD *f  = mysql_fetch_field(result);	
						x->setText(2, f->name);
						x->setText(3, QString::fromLocal8Bit(row[l]));
						x->slot_row_height(x);
					
						total++;
						if(value == total)
						{
							mysql_free_result(result);
							return FALSE;
						}
						//debug(row[l]);
					}
				}
			}
			else 
			{
				if(match_case->isChecked())
				{
					if(strstr(row[l], text->text().local8Bit().data()))
					{		
						MultiLineListViewItem *x = new MultiLineListViewItem(sql);
						x->setText(0, database);
						x->setText(1, table);
						mysql_field_seek(result, l);
						MYSQL_FIELD *f  = mysql_fetch_field(result);	
						x->setText(2, f->name);
						x->setText(3, QString::fromLocal8Bit(row[l]));
						x->slot_row_height(x);
						//debug(row[l]);
					
						total++;
						if(value == total)
						{
							mysql_free_result(result);
							return FALSE;
						}	
					}
				}
				else
				{
					if(strstr(QString(row[l]).lower().latin1(), QString(text->text().local8Bit().data()).lower().latin1()))
					{
						MultiLineListViewItem *x = new MultiLineListViewItem(sql);
						x->setText(0, database);
						x->setText(1, table);
						mysql_field_seek(result, l);
						MYSQL_FIELD *f  = mysql_fetch_field(result);	
						x->setText(2, f->name);
						x->setText(3, QString::fromLocal8Bit(row[l]));
						x->slot_row_height(x);
						//debug(row[l]);
					
						total++;
						if(value == total)
						{
							mysql_free_result(result);
							return FALSE;
						}	
					}
				}
			}
		}
	}

	mysql_free_result(result);

	return TRUE;
}

bool Find::slot_find(const QString &database)
{
	MYSQL_RES *result;
	MYSQL_ROW row;

	if(table->currentText() == "*")
	{
		if(mysql_select_db(mysql, database.latin1()))
			return FALSE;

		result = mysql_list_tables(mysql, NULL);

		if(result == NULL)
			return FALSE;

		while((row = mysql_fetch_row(result)))
		{
			if(slot_find(database, row[0]) == FALSE)
				break;
		}
		
		mysql_free_result(result);
	}
	else
	{
		slot_find(database, table->currentText());
	}
	
	
	return TRUE;
}

