<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006-2008 Malcolm Cowe
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

include("../inc/inc.Settings.php");
include("../inc/inc.AccessUtils.php");
include("../inc/inc.ClassAccess.php");
include("../inc/inc.ClassDocument.php");
include("../inc/inc.ClassFolder.php");
include("../inc/inc.ClassGroup.php");
include("../inc/inc.ClassUser.php");
include("../inc/inc.DBAccess.php");
include("../inc/inc.FileUtils.php");
include("../inc/inc.Language.php");
include("../inc/inc.ClassUI.php");
include("../inc/inc.Authentication.php");

if (!isset($_GET["documentid"]) || !is_numeric($_GET["documentid"]) || intval($_GET["documentid"])<1) {
	UI::htmlStartPage(getMLText("document_title", array("documentname" => getMLText("invalid_doc_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_doc_id"));
	UI::htmlEndPage();
	exit;
}
$documentid = $_GET["documentid"];
$document = getDocument($documentid);
if (!is_object($document)) {
	UI::htmlStartPage(getMLText("document_title", array("documentname" => getMLText("invalid_doc_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_doc_id"));
	UI::htmlEndPage();
	exit;
}

$folder = $document->getFolder();
$docPathHTML = getFolderPathHTML($folder, true). " / <a href=\"../out/out.ViewDocument.php?documentid=".$documentid."\">".$document->getName()."</a>";
UI::htmlStartPage(getMLText("document_title", array("documentname" => $document->getName())));
UI::globalNavigation($folder);
UI::pageNavigation($docPathHTML, "view_document");

if ($document->getAccessMode($user) < M_READWRITE) {
	UI::contentHeading(getMLText("expires") . ": " . $document->getName());
	UI::contentContainer(getMLText("operation_not_allowed"));
	UI::htmlEndPage();
	exit;
}

UI::contentHeading(getMLText("expires") . ": " . $document->getName());
UI::contentContainerStart();
?>
<form action="../op/op.SetExpires.php" method="POST">
	<input type="Hidden" name="documentid" value="<?php print $documentid;?>">
	<table>
		<tr>
			<td><?php printMLText("expires");?>:</td>
			<td>
				<ul class="actions">
				<li class="first"><input type="Radio" name="expires" value="false"<?php if (!$document->expires()) print " checked";?>><?php printMLText("does_not_expire");?>
				<li><input type="radio" name="expires" value="true"<?php if ($document->expires()) print " checked";?>><?php if ($document->expires()) UI::printDateChooser($document->getExpires(), "exp"); else UI::printDateChooser(-1, "exp"); ?>
				</ul>
			</td>
		</tr>
		<tr>
			<td colspan="2"><br><input type="Submit" value="<?php printMLText("set_expiry")?>"></td>
		</tr>
	</table>
</form>
<?php
UI::contentContainerEnd();
UI::htmlEndPage();
?>
