<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006-2008 Malcolm Cowe
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

include("../inc/inc.Settings.php");
include("../inc/inc.AccessUtils.php");
include("../inc/inc.ClassAccess.php");
include("../inc/inc.ClassDocument.php");
include("../inc/inc.ClassFolder.php");
include("../inc/inc.ClassGroup.php");
include("../inc/inc.ClassUser.php");
include("../inc/inc.DBAccess.php");
include("../inc/inc.Language.php");
include("../inc/inc.ClassUI.php");
include("../inc/inc.Authentication.php");

UI::htmlStartPage(getMLText("account_summary"));
UI::globalNavigation();
UI::pageNavigation(getMLText("account_summary"), "account_summary");

UI::contentHeading(getMLText("user_info")." (<a href=\"../out/out.EditUserData.php\">".getMLText("edit")."</a>)");
UI::contentContainer("<table>\n<tr>\n".
			"<td rowspan=5 id=\"userImage\">".($user->hasImage() ? "<img class=\"userImage\" src=\"".$user->getImageURL()."\">" : getMLText("no_user_image"))."</td>\n".
			"</tr>\n<tr>\n".
			"<td>".getMLText("name").":</td>\n".
			"<td>".$user->getFullName().($user->isAdmin() ? " (".getMLText("admin").")" : "")."</td>\n".
			"</tr>\n<tr>\n".
			"<td>".getMLText("user_login").":</td>\n".
			"<td>".$user->getLogin()."</td>\n".
			"</tr>\n<tr>\n".
			"<td>".getMLText("email").":</td>\n".
			"<td>".$user->getEmail()."</td>\n".
			"</tr>\n<tr>\n".
			"<td>".getMLText("comment").":</td>\n".
			"<td>".$user->getComment()."</td>\n".
			"</tr>\n</table>\n");

if (!$db->createTemporaryTable("ttstatid") || !$db->createTemporaryTable("ttcontentid")) {
	UI::contentHeading(getMLText("warning"));
	UI::contentContainer(getMLText("internal_error_exit"));
	UI::htmlEndPage();
	exit;
}

// Get document list for the current user.
$reviewStatus = $user->getReviewStatus();
$approvalStatus = $user->getApprovalStatus();

// Create a comma separated list of all the documentIDs whose information is
// required.
$dList = array();
foreach ($reviewStatus["indstatus"] as $st) {
	if (!in_array($st["documentID"], $dList)) {
		$dList[] = $st["documentID"];
	}
}
foreach ($reviewStatus["grpstatus"] as $st) {
	if (!in_array($st["documentID"], $dList)) {
		$dList[] = $st["documentID"];
	}
}
foreach ($approvalStatus["indstatus"] as $st) {
	if (!in_array($st["documentID"], $dList)) {
		$dList[] = $st["documentID"];
	}
}
foreach ($approvalStatus["grpstatus"] as $st) {
	if (!in_array($st["documentID"], $dList)) {
		$dList[] = $st["documentID"];
	}
}
$docCSV = "";
foreach ($dList as $d) {
	$docCSV .= (strlen($docCSV)==0 ? "" : ", ")."'".$d."'";
}

if (strlen($docCSV)>0) {
	// Get the document information.
	$queryStr = "SELECT `tblDocuments`.*, `tblDocumentLocks`.`userID` as `lockUser`, ".
		"`tblDocumentContent`.`version`, `tblDocumentStatus`.*, `tblDocumentStatusLog`.`status`, ".
		"`tblDocumentStatusLog`.`comment` AS `statusComment`, `tblDocumentStatusLog`.`date` as `statusDate`, ".
		"`tblDocumentStatusLog`.`userID`, `oTbl`.`fullName` AS `ownerName`, `sTbl`.`fullName` AS `statusName` ".
		"FROM `tblDocumentContent` ".
		"LEFT JOIN `tblDocuments` ON `tblDocuments`.`id` = `tblDocumentContent`.`document` ".
		"LEFT JOIN `tblDocumentStatus` ON `tblDocumentStatus`.`documentID` = `tblDocumentContent`.`document` ".
		"LEFT JOIN `tblDocumentStatusLog` ON `tblDocumentStatusLog`.`statusID` = `tblDocumentStatus`.`statusID` ".
		"LEFT JOIN `ttstatid` ON `ttstatid`.`maxLogID` = `tblDocumentStatusLog`.`statusLogID` ".
		"LEFT JOIN `ttcontentid` ON `ttcontentid`.`maxVersion` = `tblDocumentStatus`.`version` AND `ttcontentid`.`document` = `tblDocumentStatus`.`documentID` ".
		"LEFT JOIN `tblDocumentLocks` ON `tblDocuments`.`id`=`tblDocumentLocks`.`document` ".
		"LEFT JOIN `tblUsers` AS `oTbl` on `oTbl`.`id` = `tblDocuments`.`owner` ".
		"LEFT JOIN `tblUsers` AS `sTbl` on `sTbl`.`id` = `tblDocumentStatusLog`.`userID` ".
		"WHERE `ttstatid`.`maxLogID`=`tblDocumentStatusLog`.`statusLogID` ".
		"AND `ttcontentid`.`maxVersion` = `tblDocumentContent`.`version` ".
		"AND `tblDocumentStatusLog`.`status` IN (0, 1) ".
		"AND `tblDocuments`.`id` IN (" . $docCSV . ") ".
		"ORDER BY `sequence`";

	$resArr = $db->getResultArray($queryStr);
	if (is_bool($resArr) && !$resArr) {
		UI::contentHeading(getMLText("warning"));
		UI::contentContainer(getMLText("internal_error_exit"));
		UI::htmlEndPage();
		exit;
	}
	// Create an array to hold all of these results, and index the array by
	// document id. This makes it easier to retrieve document ID information
	// later on and saves us having to repeatedly poll the database every time
	// new document information is required.
	$docIdx = array();
	foreach ($resArr as $res) {
		$docIdx[$res["id"]][$res["version"]] = $res;
	}

	// List the documents where a review has been requested.
	UI::contentHeading(getMLText("documents_to_review"));
	UI::contentContainerStart();
	print "<table class=\"folderView\">";
	print "<thead>\n<tr>\n";
	print "<th></th>\n";
	print "<th>".getMLText("name")."</th>\n";
	print "<th>".getMLText("owner")."</th>\n";
	print "<th>".getMLText("status")."</th>\n";
	print "<th>".getMLText("version")."</th>\n";
	print "<th>".getMLText("last_update")."</th>\n";
	print "<th>".getMLText("actions")."</th>\n";
	print "</tr>\n</thead>\n<tbody>\n";
	$reviewListEmpty=true;
		$iRev = array();
		foreach ($reviewStatus["indstatus"] as $st) {
			if ($st["status"]==0 && isset($docIdx[$st["documentID"]][$st["version"]])) {
				print "<tr>\n";
				print "<td><img src=\"images/file.gif\" width=18 height=18 border=0></td>";
				print "<td><a href=\"out.ViewDocument.php?documentid=".$st["documentID"]."\">".$docIdx[$st["documentID"]][$st["version"]]["name"]."</a></td>";
				print "<td>".$docIdx[$st["documentID"]][$st["version"]]["ownerName"]."</td>";
				print "<td>".getOverallStatusText($docIdx[$st["documentID"]][$st["version"]]["status"])."</td>";
				print "<td class=\"center\">".$st["version"]."</td>";
				print "<td>".$st["date"];
				print " by ". $docIdx[$st["documentID"]][$st["version"]]["statusName"] ."</td>";
				print "<td><a href=\"../out/out.ReviewDocument.php?documentid=".$st["documentID"]."&version=".$st["version"]."\">".getMLText("submit_review")."</a>";
				print "</td></tr>\n";
				$reviewListEmpty=false;
			}
			if ($st["status"]!=-2) {
				$iRev[] = $st["documentID"];
			}
		}
		foreach ($reviewStatus["grpstatus"] as $st) {
			if (!in_array($st["documentID"], $iRev) && $st["status"]==0 && isset($docIdx[$st["documentID"]][$st["version"]])) {
				print "<tr>\n";
				print "<td><img src=\"images/file.gif\" width=18 height=18 border=0></td>";
				print "<td><a href=\"out.ViewDocument.php?documentid=".$st["documentID"]."\">".$docIdx[$st["documentID"]][$st["version"]]["name"]."</a></td>";
				print "<td>".$docIdx[$st["documentID"]][$st["version"]]["ownerName"]."</td>";
				print "<td>".getOverallStatusText($docIdx[$st["documentID"]][$st["version"]]["status"])."</td>";
				print "<td class=\"center\">".$st["version"]."</td>";
				echo "<td>".$st["date"];
				print " by ". $docIdx[$st["documentID"]][$st["version"]]["statusName"]."</td>";
				$g = getGroup($st["required"]);
				print "<td><a href=\"../out/out.ReviewDocument.php?documentid=".$st["documentID"]."&version=".$st["version"]."\">".getMLText("group")." '".$g->getName()."': ".getMLText("submit_review")."</a>";
				print "</td></tr>\n";
				$reviewListEmpty=false;
			}
		}
	if ($reviewListEmpty) {
		echo "<tr><td colspan=7>".getMLText("no_docs_to_review")."</td></tr>";
	}
	echo "</tbody>\n</table>";
	UI::contentContainerEnd();

	// List the documents where an approval has been requested.
	UI::contentHeading(getMLText("documents_to_approve"));
	UI::contentContainerStart();
	print "<table class=\"folderView\">";
	print "<thead>\n<tr>\n";
	print "<th></th>\n";
	print "<th>".getMLText("name")."</th>\n";
	print "<th>".getMLText("owner")."</th>\n";
	print "<th>".getMLText("status")."</th>\n";
	print "<th>".getMLText("version")."</th>\n";
	print "<th>".getMLText("last_update")."</th>\n";
	print "<th>".getMLText("actions")."</th>\n";
	print "</tr>\n</thead>\n<tbody>\n";
	$approvalListEmpty = true;
		foreach ($approvalStatus["indstatus"] as $st) {
			if ($st["status"]==0 && isset($docIdx[$st["documentID"]][$st["version"]]) && $docIdx[$st["documentID"]][$st["version"]]["status"]==1) {
				print "<tr>\n";
				print "<td><img src=\"images/file.gif\" width=18 height=18 border=0></td>";
				print "<td><a href=\"out.ViewDocument.php?documentid=".$st["documentID"]."\">".$docIdx[$st["documentID"]][$st["version"]]["name"]."</a></td>";
				print "<td>".$docIdx[$st["documentID"]][$st["version"]]["ownerName"]."</td>";
				print "<td>".getOverallStatusText($docIdx[$st["documentID"]][$st["version"]]["status"])."</td>";
				print "<td class=\"center\">".$st["version"]."</td>";
				print "<td>".$st["date"];
				print " by ". $docIdx[$st["documentID"]][$st["version"]]["statusName"] ."</td><td>";
				if ($docIdx[$st["documentID"]][$st["version"]]["status"]==0) {
					printMLText("no_action_required");
				}
				else {
					echo "<a href='../out/out.ApproveDocument.php?documentid=".$st["documentID"]."&version=".$st["version"]."'>".getMLText("submit_approval")."</a>";
				}
				print "</td>\n</tr>\n";
				$approvalListEmpty = false;
			}
			if ($st["status"]!=-2) {
				$iRev[] = $st["documentID"];
			}
		}
		foreach ($approvalStatus["grpstatus"] as $st) {
			if (!in_array($st["documentID"], $iRev) && $st["status"]==0 && isset($docIdx[$st["documentID"]][$st["version"]]) && $docIdx[$st["documentID"]][$st["version"]]["status"]==1) {
				print "<tr>\n";
				print "<td><img src=\"images/file.gif\" width=18 height=18 border=0></td>";
				print "<td><a href=\"out.ViewDocument.php?documentid=".$st["documentID"]."\">".$docIdx[$st["documentID"]][$st["version"]]["name"]."</a></td>";
				print "<td>".$docIdx[$st["documentID"]][$st["version"]]["ownerName"]."</td>";
				print "<td>".getOverallStatusText($docIdx[$st["documentID"]][$st["version"]]["status"])."</td>";
				print "<td class=\"center\">".$st["version"]."</td>";
				print "<td>".$st["date"];
				$g = getGroup($st["required"]);
				print " by ". $docIdx[$st["documentID"]][$st["version"]]["statusName"] ."</td><td>";
				if ($docIdx[$st["documentID"]][$st["version"]]["status"]==0) {
					printMLText("no_action_required");
				}
				else {
					echo "<a href='../out/out.ApproveDocument.php?documentid=".$st["documentID"]."&version=".$st["version"]."'>".getMLText("group")." '".$g->getName()."': ".getMLText("submit_approval")."</a>";
				}
				print "</td>\n</tr>\n";
				$approvalListEmpty = false;
			}
		}
	if ($approvalListEmpty) {
		echo "<tr><td colspan=7>".getMLText("no_docs_to_approve")."</td></tr>";
	}
	echo "</tbody>\n</table>\n";
	UI::contentContainerEnd();
}
else {
		UI::contentHeading(getMLText("documents_to_review"));
		UI::contentContainer(getMLText("no_docs_to_review"));
		UI::contentHeading(getMLText("documents_to_approve"));
		UI::contentContainer(getMLText("no_docs_to_approve"));
}


// Get list of documents owned by current user that are pending review or
// pending approval.
$queryStr = "SELECT `tblDocuments`.*, `tblDocumentLocks`.`userID` as `lockUser`, ".
	"`tblDocumentContent`.`version`, `tblDocumentStatus`.*, `tblDocumentStatusLog`.`status`, ".
	"`tblDocumentStatusLog`.`comment` AS `statusComment`, `tblDocumentStatusLog`.`date` as `statusDate`, ".
	"`tblDocumentStatusLog`.`userID`, `oTbl`.`fullName` AS `ownerName`, `sTbl`.`fullName` AS `statusName` ".
	"FROM `tblDocumentContent` ".
	"LEFT JOIN `tblDocuments` ON `tblDocuments`.`id` = `tblDocumentContent`.`document` ".
	"LEFT JOIN `tblDocumentStatus` ON `tblDocumentStatus`.`documentID` = `tblDocumentContent`.`document` ".
	"LEFT JOIN `tblDocumentStatusLog` ON `tblDocumentStatusLog`.`statusID` = `tblDocumentStatus`.`statusID` ".
	"LEFT JOIN `ttstatid` ON `ttstatid`.`maxLogID` = `tblDocumentStatusLog`.`statusLogID` ".
	"LEFT JOIN `ttcontentid` ON `ttcontentid`.`maxVersion` = `tblDocumentStatus`.`version` AND `ttcontentid`.`document` = `tblDocumentStatus`.`documentID` ".
	"LEFT JOIN `tblDocumentLocks` ON `tblDocuments`.`id`=`tblDocumentLocks`.`document` ".
	"LEFT JOIN `tblUsers` AS `oTbl` on `oTbl`.`id` = `tblDocuments`.`owner` ".
	"LEFT JOIN `tblUsers` AS `sTbl` on `sTbl`.`id` = `tblDocumentStatusLog`.`userID` ".
	"WHERE `ttstatid`.`maxLogID`=`tblDocumentStatusLog`.`statusLogID` ".
	"AND `ttcontentid`.`maxVersion` = `tblDocumentContent`.`version` ".
	"AND `tblDocuments`.`owner` = '".$user->getID()."' ".
	"AND `tblDocumentStatusLog`.`status` IN (0, 1) ".
	"ORDER BY `sequence`";

$resArr = $db->getResultArray($queryStr);
if (is_bool($resArr) && !$resArr) {
	UI::contentHeading(getMLText("warning"));
	UI::contentContainer("Internal error. Unable to complete request. Exiting.");
	UI::htmlEndPage();
	exit;
}

UI::contentHeading(getMLText("documents_user_requiring_attention"));
UI::contentContainerStart();
print "<table class=\"folderView\">";
print "<thead>\n<tr>\n";
print "<th></th>\n";
print "<th>".getMLText("name")."</th>\n";
print "<th>".getMLText("owner")."</th>\n";
print "<th>".getMLText("status")."</th>\n";
print "<th>".getMLText("version")."</th>\n";
print "<th>".getMLText("last_update")."</th>\n";
print "<th>".getMLText("actions")."</th>\n";
print "</tr>\n</thead>\n<tbody>\n";

if (count($resArr)>0) {
	foreach ($resArr as $res) {
		print "<tr>\n";
		print "<td><img src=\"images/file.gif\" width=18 height=18 border=0></td>";
		print "<td><a href=\"out.ViewDocument.php?documentid=".$res["documentID"]."\">" . $res["name"] . "</a></td>\n";
		print "<td>".$res["ownerName"]."</td>";
		print "<td>".getOverallStatusText($res["status"])."</td>";
		print "<td class=\"center\">".$res["version"]."</td>";
		print "<td>".$res["statusDate"];
		print " by ". $res["statusName"];
		print "</td><td>";
		print "<a href='../out/out.OverrideContentStatus.php?documentid=".$res["documentID"]."&version=".$res["version"]."'>Override Status</a>";
		print "</td></tr>\n";
	}
}
else {
	echo "<tr><td colspan=7>".getMLText("no_active_user_docs")."</td></tr>";
}
print "</tbody></table>";
UI::contentContainerEnd();
UI::htmlEndPage();
?>
