<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006-2008 Malcolm Cowe
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

include("../inc/inc.Settings.php");
include("../inc/inc.AccessUtils.php");
include("../inc/inc.ClassAccess.php");
include("../inc/inc.ClassDocument.php");
include("../inc/inc.ClassEmail.php");
include("../inc/inc.ClassFolder.php");
include("../inc/inc.ClassGroup.php");
include("../inc/inc.ClassUser.php");
include("../inc/inc.DBAccess.php");
include("../inc/inc.FileUtils.php");
include("../inc/inc.Utils.php");
include("../inc/inc.Language.php");
include("../inc/inc.ClassUI.php");
include("../inc/inc.Authentication.php");

if (!isset($_POST["documentid"]) || !is_numeric($_POST["documentid"]) || intval($_POST["documentid"])<1) {
	UI::htmlStartPage(getMLText("document_title", array("documentname" => getMLText("invalid_doc_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_doc_id"));
	UI::htmlEndPage();
	exit;
}
$documentid = $_POST["documentid"];
$document = getDocument($documentid);
if (!is_object($document)) {
	UI::htmlStartPage(getMLText("document_title", array("documentname" => getMLText("invalid_doc_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_doc_id"));
	UI::htmlEndPage();
	exit;
}

$folder = $document->getFolder();
$docPathHTML = getFolderPathHTML($folder, true). " / <a href=\"../out/out.ViewDocument.php?documentid=".$documentid."\">".$document->getName()."</a>";
UI::htmlStartPage(getMLText("document_title", array("documentname" => $document->getName())));
UI::globalNavigation($folder);
UI::pageNavigation($docPathHTML, "view_document");
UI::contentHeading(getMLText("update_reviewers_approvers"));

if ($document->getAccessMode($user) < M_ALL) {
	UI::contentContainer(getMLText("assign_privilege_insufficient"));
	UI::htmlEndPage();
	exit;
}

if (!isset($_POST["version"]) || !is_numeric($_POST["version"]) || intval($_POST["version"])<1) {
	UI::contentContainer(getMLText("invalid_version"));
	UI::htmlEndPage();
	exit;
}
$version = $_POST["version"];
$content = $document->getContentByVersion($version);
if (!is_object($content)) {
	// die ("Unable to retrieve version information for document '". $document->getName() ."', version ". $version .".");
	UI::contentContainer(getMLText("invalid_version"));
	UI::htmlEndPage();
	exit;
}

// Retrieve a list of all users and groups that have review / approve
// privileges.
$docAccess = $document->getApproversList();
$accessIndex = array("i"=>array(), "g"=>array());
foreach ($docAccess["users"] as $i=>$da) {
	$accessIndex["i"][$da->getID()] = $i;
}
foreach ($docAccess["groups"] as $i=>$da) {
	$accessIndex["g"][$da->getID()] = $i;
}

// Retrieve overall status.
$overallStatus = $content->getStatus();
if ($overallStatus["status"]!=0 && $overallStatus["status"]!=1) {
	UI::contentContainer(getMLText("cannot_assign_invalid_state"));
	UI::htmlEndPage();
	exit;
}

// Retrieve list of currently assigned reviewers and approvers, along with
// their latest status.
$reviewStatus = $content->getReviewStatus();
$approvalStatus = $content->getApprovalStatus();
// Index the review results for easy cross-reference with the Approvers List.
$reviewIndex = array("i"=>array(), "g"=>array());
foreach ($reviewStatus as $i=>$rs) {
	if ($rs["status"]!=-2) {
		if ($rs["type"]==0) {
			$reviewIndex["i"][$rs["required"]] = array("status"=>$rs["status"], "idx"=>$i);
		}
		else if ($rs["type"]==1) {
			$reviewIndex["g"][$rs["required"]] = array("status"=>$rs["status"], "idx"=>$i);
		}
	}
}
// Index the approval results for easy cross-reference with the Approvers List.
$approvalIndex = array("i"=>array(), "g"=>array());
foreach ($approvalStatus as $i=>$rs) {
	if ($rs["status"]!=-2) {
		if ($rs["type"]==0) {
			$approvalIndex["i"][$rs["required"]] = array("status"=>$rs["status"], "idx"=>$i);
		}
		else if ($rs["type"]==1) {
			$approvalIndex["g"][$rs["required"]] = array("status"=>$rs["status"], "idx"=>$i);
		}
	}
}

UI::contentContainerStart();
$noAction=true;

print "<ul class=\"reviewer\">";
if (isset($_POST["assignDocReviewers"]) && $_POST["assignDocReviewers"]==1) {
	// Get the list of proposed reviewers, stripping out any duplicates.
	$pIndRev = (isset($_POST["indReviewers"]) ? array_values(array_unique($_POST["indReviewers"])) : array());
	$pGrpRev = (isset($_POST["grpReviewers"]) ? array_values(array_unique($_POST["grpReviewers"])) : array());
	foreach ($pIndRev as $p) {
		if (is_numeric($p)) {
			if (isset($accessIndex["i"][$p])) {
				// Proposed reviewer is on the list of possible reviewers.
				if (!isset($reviewIndex["i"][$p])) {
					// Proposed reviewer is not a current reviewer, so add as a new
					// reviewer.
					$res = $content->addIndReviewer($docAccess["users"][$accessIndex["i"][$p]], $user, true);
					$unm = $docAccess["users"][$accessIndex["i"][$p]]->getFullName();
					$uml = $docAccess["users"][$accessIndex["i"][$p]]->getEmail();
					switch ($res) {
						case 0:
							echo "<li".($noAction ? "class=\"first\"" : "").">".$unm." &lt;".$uml."> ".getMLText("reviewer_added").". ".getMLText("email_sent").".</li>";
							break;
						case -1:
							echo "<li".($noAction ? "class=\"first\"" : "").">Unable to add ".$unm." &lt;".$uml."> ".getMLText("reviewer_added").". ".getMLText("internal_error").".</li>";
							break;
						case -2:
							print "<li".($noAction ? "class=\"first\"" : "").">".$unm." &lt;".$uml."> ".getMLText("reviewer_no_privilege").".</li>";
							break;
						case -3:
							print "<li".($noAction ? "class=\"first\"" : "").">".$unm." &lt;".$uml."> ".getMLText("reviewer_already_assigned").".</li>";
							break;
						case -4:
							print "<li".($noAction ? "class=\"first\"" : "").">".$unm." &lt;".$uml."> ".getMLText("reviewer_added").". ";
							print getMLText("email_err_user").".</li>";
							break;
					}
					$noAction=false;
				}
				else {
					// Remove reviewer from the index of possible reviewers. If there are
					// any reviewers left over in the list of possible reviewers, they
					// will be removed from the review process for this document revision.
					unset($reviewIndex["i"][$p]);
				}
			}
		}
	}
	if (count($reviewIndex["i"]) > 0) {
		foreach ($reviewIndex["i"] as $rx=>$rv) {
			if ($rv["status"] == 0) {
				// User is to be removed from the review list.
				if (!isset($docAccess["users"][$accessIndex["i"][$rx]])) {
					// User does not have any review privileges for this document
					// revision or does not exist.
					$queryStr = "INSERT INTO `tblDocumentReviewLog` (`reviewID`, `status`, `comment`, `date`, `userID`) ".
						"VALUES ('". $reviewStatus[$rv["idx"]]["reviewID"] ."', '-2', 'Reviewer removed from process', NOW(), '". $user->getID() ."')";
					echo $queryStr;
					$res = $db->getResult($queryStr);
				}
				else {
					$res = $content->delIndReviewer($docAccess["users"][$accessIndex["i"][$rx]], $user, true);
					$unm = $docAccess["users"][$accessIndex["i"][$rx]]->getFullName();
					$uml = $docAccess["users"][$accessIndex["i"][$rx]]->getEmail();
					switch ($res) {
						case 0:
							echo "<li".($noAction ? "class=\"first\"" : "").">".$unm." &lt;".$uml."> ".getMLText("reviewer_removed").". ".getMLText("email_sent").".</li>";
							break;
						case -1:
							echo "<li".($noAction ? "class=\"first\"" : "").">".getMLText("unable_to_remove")." ".$unm." &lt;".$uml."> ".getMLText("from_review_process").". ".getMLText("internal_error").".</li>";
							break;
						case -3:
							print "<li".($noAction ? "class=\"first\"" : "").">".$unm." &lt;".$uml."> ".getMLText("reviewer_already_removed").".</li>";
							break;
						case -4:
							print "<li".($noAction ? "class=\"first\"" : "").">".$unm." &lt;".$uml."> ".getMLText("reviewer_removed").". ";
							print getMLText("email_err_user").".</li>";
							break;
					}
					$noAction=false;
				}
			}
		}
	}
	foreach ($pGrpRev as $p) {
		if (is_numeric($p)) {
			if (isset($accessIndex["g"][$p])) {
				// Proposed reviewer is on the list of possible reviewers.
				if (!isset($reviewIndex["g"][$p])) {
					// Proposed reviewer is not a current reviewer, so add as a new
					// reviewer.
					$res = $content->addGrpReviewer($docAccess["groups"][$accessIndex["g"][$p]], $user, true);
					$gnm = $docAccess["groups"][$accessIndex["g"][$p]]->getName();
					switch ($res) {
						case 0:
							echo "<li".($noAction ? "class=\"first\"" : "").">".getMLText("group")." '".$gnm."' ".getMLText("reviewer_added").". ".getMLText("group_email_sent").".</li>";
							break;
						case -1:
							echo "<li".($noAction ? "class=\"first\"" : "").">".getMLText("group_unable_to_add")." '".$reviewer->getName()."' ".getMLText("as_reviewer").". ".getMLText("internal_error").".</li>";
							break;
						case -2:
							echo "<li".($noAction ? "class=\"first\"" : "").">".getMLText("group")." '".$gnm."' ".getMLText("reviewer_no_privilege").".</li>";
							break;
						case -3:
							echo "<li".($noAction ? "class=\"first\"" : "").">".getMLText("group")." '".$gnm."' ".getMLText("reviewer_already_assigned").".</li>";
							break;
						case -4:
							echo "<li".($noAction ? "class=\"first\"" : "").">".getMLText("group")." '".$gnm."' ".getMLText("reviewer_added").". ".getMLText("email_err_group").".</li>";
							break;
					}
					$noAction=false;
				}
				else {
					// Remove reviewer from the index of possible reviewers.
					unset($reviewIndex["g"][$p]);
				}
			}
		}
	}
	if (count($reviewIndex["g"]) > 0) {
		foreach ($reviewIndex["g"] as $rx=>$rv) {
			if ($rv["status"] == 0) {
				// Group is to be removed from the review list.
				if (!isset($docAccess["groups"][$accessIndex["g"][$rx]])) {
					// Group does not have any review privileges for this document
					// revision or does not exist.
					$queryStr = "INSERT INTO `tblDocumentReviewLog` (`reviewID`, `status`, `comment`, `date`, `userID`) ".
						"VALUES ('". $reviewStatus[$rv["idx"]]["reviewID"] ."', '-2', 'Reviewer removed from process', NOW(), '". $user->getID() ."')";
					echo $queryStr;
					$res = $db->getResult($queryStr);
				}
				else {
					$res = $content->delGrpReviewer($docAccess["groups"][$accessIndex["g"][$rx]], $user, true);
					$gnm = $docAccess["groups"][$accessIndex["g"][$rx]]->getName();
					switch ($res) {
						case 0:
							echo "<li".($noAction ? "class=\"first\"" : "").">".getMLText("group")." '".$gnm."' ".getMLText("reviewer_removed").". ".getMLText("group_email_sent").".</li>";
							break;
						case -1:
							echo "<li".($noAction ? "class=\"first\"" : "").">".getMLText("group_unable_to_remove")." '".$gnm."' ".getMLText("from_review_process").". ".getMLText("internal_error").".</li>";
							break;
						case -3:
							echo "<li".($noAction ? "class=\"first\"" : "").">".getMLText("group")." '".$gnm."' ".getMLText("reviewer_already_removed").".</li>";
							break;
						case -4:
							echo "<li".($noAction ? "class=\"first\"" : "").">".getMLText("group")." '".$gnm."' ".getMLText("reviewer_removed").". ";
							echo getMLText("email_err_group").".</li>";
							break;
					}
					$noAction=false;
				}
			}
		}
	}
}

if (isset($_POST["assignDocApprovers"]) && $_POST["assignDocApprovers"]==1) {
	// Get the list of proposed approvers, stripping out any duplicates.
	$pIndApp = (isset($_POST["indApprovers"]) ? array_values(array_unique($_POST["indApprovers"])) : array());
	$pGrpApp = (isset($_POST["grpApprovers"]) ? array_values(array_unique($_POST["grpApprovers"])) : array());
	foreach ($pIndApp as $p) {
		if (is_numeric($p)) {
			if (isset($accessIndex["i"][$p])) {
				// Proposed approver is on the list of possible approvers.
				if (!isset($approvalIndex["i"][$p])) {
					// Proposed approver is not a current approver, so add as a new
					// approver.
					$res = $content->addIndApprover($docAccess["users"][$accessIndex["i"][$p]], $user, ($overallStatus["status"]==0 ? false : true));
					$unm = $docAccess["users"][$accessIndex["i"][$p]]->getFullName();
					$uml = $docAccess["users"][$accessIndex["i"][$p]]->getEmail();
					switch ($res) {
						case 0:
							echo "<li".($noAction ? "class=\"first\"" : "").">".$unm." &lt;".$uml."> ".getMLText("approver_added").".".($overallStatus["status"]==0 ? " ".getMLText("email_sent")."." : "")."</li>";
							break;
						case -1:
							echo "<li".($noAction ? "class=\"first\"" : "").">".getMLText("unable_to_add")." ".$unm." &lt;".$uml."> ".getMLText("as_approver").". ".getMLText("internal_error").".</li>";
							break;
						case -2:
							print "<li".($noAction ? "class=\"first\"" : "").">".$unm." &lt;".$uml."> ".getMLText("approver_no_privilege").".</li>";
							break;
						case -3:
							print "<li".($noAction ? "class=\"first\"" : "").">".$unm." &lt;".$uml."> ".getMLText("approver_already_assigned").".</li>";
							break;
						case -4:
							print "<li".($noAction ? "class=\"first\"" : "").">".$unm." &lt;".$uml."> ".getMLText("approver_added").". ";
							print getMLText("email_err_user").".</li>";
							break;
					}
					$noAction=false;
				}
				else {
					// Remove approver from the index of possible approvers.
					unset($approvalIndex["i"][$p]);
				}
			}
		}
	}
	if (count($approvalIndex["i"]) > 0) {
		foreach ($approvalIndex["i"] as $rx=>$rv) {
			if ($rv["status"] == 0) {
				// User is to be removed from the approvers list.
				if (!isset($docAccess["users"][$accessIndex["i"][$rx]])) {
					// User does not have any approval privileges for this document
					// revision or does not exist.
					$queryStr = "INSERT INTO `tblDocumentApproveLog` (`approveID`, `status`, `comment`, `date`, `userID`) ".
						"VALUES ('". $approvalStatus[$rv["idx"]]["approveID"] ."', '-2', 'Approver removed from process', NOW(), '". $user->getID() ."')";
					$res = $db->getResult($queryStr);
				}
				else {
					$res = $content->delIndApprover($docAccess["users"][$accessIndex["i"][$rx]], $user, true);
					$unm = $docAccess["users"][$accessIndex["i"][$rx]]->getFullName();
					$uml = $docAccess["users"][$accessIndex["i"][$rx]]->getEmail();
					switch ($res) {
						case 0:
							echo "<li".($noAction ? "class=\"first\"" : "").">".$unm." &lt;".$uml."> ".getMLText("approver_removed").". ".getMLText("email_sent").".</li>";
							break;
						case -1:
							echo "<li".($noAction ? "class=\"first\"" : "").">".getMLText("unable_to_remove")." ".$unm." &lt;".$uml."> ".getMLText("from_approval_process").". ".getMLText("internal_error").".</li>";
							break;
						case -3:
							print "<li".($noAction ? "class=\"first\"" : "").">".$unm." &lt;".$uml."> ".getMLText("approver_already_removed").".</li>";
							break;
						case -4:
							print "<li".($noAction ? "class=\"first\"" : "").">".$unm." &lt;".$uml."> ".getMLText("approver_removed").". ";
							print getMLText("email_err_user").".</li>";
							break;
					}
					$noAction=false;
				}
			}
		}
	}
	foreach ($pGrpApp as $p) {
		if (is_numeric($p)) {
			if (isset($accessIndex["g"][$p])) {
				// Proposed approver is on the list of possible approvers.
				if (!isset($approvalIndex["g"][$p])) {
					// Proposed approver is not a current approver, so add as a new
					// approver.
					$res = $content->addGrpApprover($docAccess["groups"][$accessIndex["g"][$p]], $user, ($overallStatus["status"]==0 ? false : true));
					$gnm = $docAccess["groups"][$accessIndex["g"][$p]]->getName();
					switch ($res) {
						case 0:
							echo "<li".($noAction ? "class=\"first\"" : "").">".getMLText("group")." '".$gnm."' ".getMLText("approver_added").".".($overallStatus["status"]==0 ? " ".getMLText("group_email_sent")."." : "")."</li>";
							break;
						case -1:
							echo "<li".($noAction ? "class=\"first\"" : "").">".getMLText("group_unable_to_add")." '".$reviewer->getName()."' ".getMLText("as_approver").". ".getMLText("internal_error").".</li>";
							break;
						case -2:
							echo "<li".($noAction ? "class=\"first\"" : "").">".getMLText("group")." '".$gnm."' ".getMLText("approver_no_privilege").".</li>";
							break;
						case -3:
							echo "<li".($noAction ? "class=\"first\"" : "").">".getMLText("group")." '".$gnm."' ".getMLText("approver_already_assigned").".</li>";
							break;
						case -4:
							echo "<li".($noAction ? "class=\"first\"" : "").">".getMLText("group")." '".$gnm."' ".getMLText("approver_added").". ".getMLText("email_err_group").".</li>";
							break;
					}
					$noAction=false;
				}
				else {
					// Remove approver from the index of possible approvers.
					unset($approvalIndex["g"][$p]);
				}
			}
		}
	}
	if (count($approvalIndex["g"]) > 0) {
		foreach ($approvalIndex["g"] as $rx=>$rv) {
			if ($rv["status"] == 0) {
				// User is to be removed from the approvers list.
				if (!isset($docAccess["groups"][$accessIndex["g"][$rx]])) {
					// Group does not have any approval privileges for this document
					// revision or does not exist.
					$queryStr = "INSERT INTO `tblDocumentApproveLog` (`approveID`, `status`, `comment`, `date`, `userID`) ".
						"VALUES ('". $approvalStatus[$rv["idx"]]["approveID"] ."', '-2', 'Approver removed from process', NOW(), '". $user->getID() ."')";
					$res = $db->getResult($queryStr);
				}
				else {
					$res = $content->delGrpApprover($docAccess["groups"][$accessIndex["g"][$rx]], $user, true);
					$gnm = $docAccess["groups"][$accessIndex["g"][$rx]]->getName();
					switch ($res) {
						case 0:
							echo "<li".($noAction ? "class=\"first\"" : "").">".getMLText("group")." ".$gnm." ".getMLText("approver_removed").". ".getMLText("group_email_sent").".</li>";
							break;
						case -1:
							echo "<li".($noAction ? "class=\"first\"" : "").">".getMLText("group_unable_to_remove")." ".$gnm." ".getMLText("from_approval_process").". ".getMLText("internal_error").".</li>";
							break;
						case -3:
							echo "<li".($noAction ? "class=\"first\"" : "").">".getMLText("group")." ".$gnm." ".getMLText("approver_already_removed").".</li>";
							break;
						case -4:
							echo "<li".($noAction ? "class=\"first\"" : "").">".getMLText("group")." ".$gnm." ".getMLText("approver_removed").". ";
							echo getMLText("email_err_group").".</li>";
							break;
					}
					$noAction=false;
				}
			}
		}
	}
}
print "</ul>";

if ($noAction) {
	printMLText("no_action");
}
UI::contentContainerEnd();
UI::htmlEndPage();
?>
