/********************************************************************
 *                                                                  *
 * cardtools.c                                                      *
 *                                                                  *
 ********************************************************************
 *                                                                  *
 * Authors:                                                         *
 *   Mario Strasser       <mast@gmx.net>                            *
 *   Martin Sgesser      <m.sagi@bluemail.ch>                      *
 *                                                                  *
 ********************************************************************
 *                                                                  *
 * Cardtools library.                                               *
 *                                                                  *
 * Usefull library for SmartCard-Programs.                          *
 *                                                                  *
 ********************************************************************/


#include <winscard.h>
#include <stdlib.h>
#include <string.h>
#include <musclecard.h>
#include "cardtools.h"


SCARDCONTEXT context;
SCARDHANDLE card;
MSCUChar8 CLA;

int pcsc_init(MSCLPTokenConnection pConnection, int num)
{
  MSCLong32 rv;
  //int i;
  MSCTokenInfo tokenList[20];
  MSCULong32 arrayLength;

  (void)num;

  arrayLength = 20;

  rv = MSCListTokens(MSC_LIST_KNOWN, tokenList, &arrayLength);

  if ( (rv != MSC_SUCCESS) || (arrayLength == 0) ) {
    return MSC_INTERNAL_ERROR;
  }

  rv = MSCEstablishConnection( &tokenList[0], SCARD_SHARE_SHARED, 
                               0, 0, pConnection );

  return rv;
}

void pcsc_release(MSCLPTokenConnection pConnection)
{
  MSCLong32 rv;

  /* disconnect from card, ignore result */
  
  rv = MSCReleaseConnection(pConnection, MSC_RESET_TOKEN);

}
