//streams.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010
 *
 *  This file is part of RoarD,
 *  a sound server daemon for using the RoarAudio protocol.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  or (at your option) any later version as published by
 *  the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef _MUROARD_STREAMS_H_
#define _MUROARD_STREAMS_H_

#define STREAM_STATE_UNUSED    0
#define STREAM_STATE_NEW       1
#define STREAM_STATE_OLD       2
#define STREAM_STATE_EXECED    3
#define STREAM_STATE_CLOSING   4

#define STREAM_DATADIR_IN      1
#define STREAM_DATADIR_OUT     2

struct muroar_audio_info {
 int channels;
 int bits;
 int codec;
};

struct muroard_stream {
 // general data and IO:
 int state;
 int sock;
 int client;
 int datadir;
 // Stream level data:
 int dir;
 // audio level data:
 struct muroar_audio_info info;
 // raw data:
 int16_t * iobuf;
} g_stream[MUROAR_MAX_STREAMS];

int stream_init(void);
int stream_free(void);
int stream_new(int client, int dir, struct muroar_audio_info * info);
int stream_delete(int id);
int stream_exec(int id);

int stream_read(int id);
#ifdef MUROAR_FEATURE_MONITOR
int stream_write(int id, int16_t * buf);
#endif

#ifdef MUROAR_FEATURE_CMD_ATTACH
int stream_move_client(int id, int client);
#endif

#define stream_exist(id)       (((uint16_t)(id)) == (uint16_t)-1 || g_stream[(id)].state == STREAM_STATE_UNUSED ?  0   : 1)
#define stream_get_sock(id)    (g_stream[(id)].state == STREAM_STATE_UNUSED ? -1   : g_stream[(id)].sock)
#define stream_set_sock(id, s) (g_stream[(id)].state == STREAM_STATE_UNUSED || g_stream[(id)].sock != -1 ? \
                                -1  : (g_stream[(id)].sock = (s)) && 0)

#define stream_get_iobuf(id)   (g_stream[(id)].state == STREAM_STATE_UNUSED ? NULL : g_stream[(id)].iobuf)
#define stream_get_datadir(id) (g_stream[(id)].state == STREAM_STATE_UNUSED ? -1   : g_stream[(id)].datadir)

#endif

//ll
