#include <config.h>
#define DBUS_API_SUBJECT_TO_CHANGE
#include <dbus/dbus.h>
#include <glib/dbus-glib.h>
#include <glib.h>
       #include <sys/ipc.h>

       #include <sys/shm.h>
#include <pi-source.h>
#include <pi-socket.h>
#include <pi-dlp.h>
#include <pi-address.h>

#include <gpilotd/gnome-pilot-conduit.h>
#include <gpilotd/gnome-pilot-conduit-sync-abs.h>
#include <libgpilotdCM/gnome-pilot-conduit-management.h>
#include <libgpilotdCM/gnome-pilot-conduit-config.h>

GnomePilotConduit * conduit_get_gpilot_conduit (guint32);
void conduit_destroy_gpilot_conduit (GnomePilotConduit*);

#define CONDUIT_VERSION "0.1.2"

#define DEBUG_CONDUIT 1
/* #undef DEBUG_CONDUIT */

#ifdef DEBUG_CONDUIT
#define LOG(x) x
#else
#define LOG(x)
#endif 

#define WARN g_warning
#define INFO g_message

gint *synchronize(GnomePilotConduitStandard* conduit, GnomePilotDBInfo* dbi, gpointer user_data)
{

	int l, n, ret;
	struct AddressAppInfo aai;
	unsigned char buffer[65536];
	recordid_t id=0;
	int index, size, attr, category;
	struct Address address;
	int shmid;
	key_t key;
	void *addr;
	int perm = 0666;

	printf("blubb\n");

	l = dlp_ReadAppBlock(dbi->pilot_socket, dbi->db_handle, 0, buffer, 0xffff);

	if ((shmid=shmget(key, sizeof(*dbi), IPC_CREAT|perm)) == -1) {
		printf("shmget (key:0x%x,size:%d,perm:0x%x. pid:%ld)\n", key, size, perm,getpid());
		perror("test");
	} else {
		printf("OK ... id = %d\n", shmid);
	}

	if ((addr = shmat(shmid, (char *)NULL, 0666)) == (void *)-1){
		perror("test2");
	}

	for (n = 0; dlp_ReadRecordByIndex(dbi->pilot_socket, dbi->db_handle, n, buffer, &id, &size, &attr, &category) >= 0; n++) {
		unpack_Address(&address, buffer, l);

		for (n = 0; n < 19; n++) {
			printf("name: %s\n", address.entry[n]);
		}
	}
	DBusConnection *client;
	DBusError derror;
	GMainLoop *loop;
	DBusMessage *message;
	DBusMessageIter iter;

	dbus_error_init (&derror);

	client = dbus_connection_open("unix:path=/tmp/palmsync-dbus", &derror);
	if (!client) {
		printf ("Failed: %s\n", derror.message);
		dbus_error_free (&derror);
		return;
	}

	dbus_connection_ref (client);

	message = dbus_message_new_signal  	("/org/multisync/test",
		"org.multisync.test",
		"test"
	);

	printf("dbi socket: %i, handle: %i\n", dbi->pilot_socket, dbi->db_handle);

	if (message == NULL)
	{
		fprintf (stderr, "Couldn't allocate D-BUS message\n");
		exit (1);
	}
	dbus_message_append_iter_init (message, &iter);
	dbus_message_iter_append_int32 (&iter, dbi->pilot_socket);
	dbus_message_iter_append_int32 (&iter, dbi->db_handle);

	if (!dbus_connection_send (client,
					message,
					NULL))
	{
		printf ("thread: send message failed\n");
	}
	//   dbus_message_unref (message);

	dbus_connection_flush  	(   client);

	printf("synchronize: %s\n", user_data);

	sleep(10);
}

GnomePilotConduit *
conduit_get_gpilot_conduit (guint32 pilot_id)
{
	GtkObject *retval;
	char *test = "test";

	LOG (g_message ( "in multisync's conduit_get_gpilot_conduit\n" ));

	retval = (GtkObject *)gnome_pilot_conduit_standard_abs_new("AddressDB", 0x61646472);
	g_assert (retval != NULL);
	
	gtk_signal_connect (retval, "synchronize", (GtkSignalFunc) synchronize, test);

	return GNOME_PILOT_CONDUIT (retval);
}

void
conduit_destroy_gpilot_conduit (GnomePilotConduit *conduit)
{
	gtk_object_destroy (GTK_OBJECT (conduit));
}
