import zope.interface

class HookExecutor(object):
    def __init__(self, registry, hooks):
        self.registry = registry
        self._hooks = {}

        for i in hooks:
            self.enable_hook(i)

    def __call__(self, i, func, *args, **kw):
        c = self._hooks.get(i, [])
        for priority, cls in c:
            f = getattr(cls, func)
            f(*args, **kw)

    def __getitem__(self, i):
        return [j[1] for j in self._hooks[i]]

    @staticmethod
    def _cmp_hooks(a, b):
        return cmp(a[0], b[0])

    def enable_hook(self, hook):
        cls = self.registry[hook]
        priority = getattr(cls, 'default_priority', None)

        for i in zope.interface.implementedBy(cls):
            try:
                h = cls()
                self.insert_hook(h, priority, i)
            except TypeError: pass
        for i in zope.interface.providedBy(cls):
            self.insert_hook(cls, priority, i)

    def insert_hook(self, hook, priority, interface):
        c = self._hooks.get(interface, [])
        c.append((priority, hook))
        c.sort(self._cmp_hooks)
        self._hooks[interface] = c

