/***************************************************************************
 *   Copyright (C) 2008-2009 by Heiko Koehn  ( KoehnHeiko@googlemail.com )      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "XMLexport.h"

using namespace std;

XMLexport::XMLexport( Host * pH )
: mpHost( pH )
, mType( "Host" )
{
    setAutoFormatting(true);
}

XMLexport::XMLexport( Host * pT, bool b )
: mpHost( pT )
, mType( "GenericPackage" )
{
    setAutoFormatting(true);
}


XMLexport::XMLexport( TTrigger * pT )
: mpTrigger( pT )
, mType( "Trigger" )
{
    setAutoFormatting(true);
}

XMLexport::XMLexport( TTimer * pT )
: mpTimer( pT )
, mType( "Timer" )
{
    setAutoFormatting(true);
}

XMLexport::XMLexport( TAlias * pT )
: mpAlias( pT )
, mType( "Alias" )
{
    setAutoFormatting(true);
}

XMLexport::XMLexport( TAction * pT )
: mpAction( pT )
, mType( "Action" )
{
    setAutoFormatting(true);
}

XMLexport::XMLexport( TScript * pT )
: mpScript( pT )
, mType( "Script" )
{
    setAutoFormatting(true);
}

XMLexport::XMLexport( TKey * pT )
: mpKey( pT )
, mType( "Key" )
{
    setAutoFormatting(true);
}

bool XMLexport::exportHost( QIODevice * device )
{
    setDevice(device);

    writeStartDocument();
    writeDTD("<!DOCTYPE MudletPackage>");

    writeStartElement( "MudletPackage" );
    writeAttribute("version", "1.0");

    writeStartElement( "HostPackage" );
    writeHost( mpHost );
    writeEndElement();

    writeEndElement();//MudletPackage
    writeEndDocument();
    return true;
}

bool XMLexport::writeHost( Host * pT )
{
    writeStartElement( "Host" );

    writeAttribute( "autoClearCommandLineAfterSend", pT->mAutoClearCommandLineAfterSend ? "yes" : "no" );
    writeAttribute( "disableAutoCompletion", pT->mDisableAutoCompletion ? "yes" : "no" );
    writeAttribute( "printCommand", pT->mPrintCommand ? "yes" : "no" );
    writeAttribute( "USE_IRE_DRIVER_BUGFIX", pT->mUSE_IRE_DRIVER_BUGFIX ? "yes" : "no" );
    writeAttribute( "mUSE_FORCE_LF_AFTER_PROMPT", pT->mUSE_FORCE_LF_AFTER_PROMPT ? "yes" : "no" );
    writeAttribute( "mUSE_UNIX_EOL", pT->mUSE_UNIX_EOL ? "yes" : "no" );
    writeAttribute( "mNoAntiAlias", pT->mNoAntiAlias ? "yes" : "no" );
    writeAttribute( "mRawStreamDump", pT->mRawStreamDump ? "yes" : "no" );
    writeAttribute( "mAlertOnNewData", pT->mAlertOnNewData ? "yes" : "no" );
    writeAttribute( "mFORCE_NO_COMPRESSION", pT->mFORCE_NO_COMPRESSION ? "yes" : "no" );
    writeAttribute( "mFORCE_GA_OFF", pT->mFORCE_GA_OFF ? "yes" : "no" );
    writeAttribute( "mFORCE_SAVE_ON_EXIT", pT->mFORCE_SAVE_ON_EXIT ? "yes" : "no" );
    writeAttribute( "mEnableGMCP", pT->mEnableGMCP ? "yes" : "no" );
    writeAttribute( "mMapStrongHighlight", pT->mMapStrongHighlight ? "yes" : "no" );
    writeAttribute( "mLogStatus", pT->mLogStatus ? "yes" : "no" );
    writeAttribute( "mEnableSpellCheck", pT->mEnableSpellCheck ? "yes" : "no" );

    writeTextElement( "name", pT->mHostName );
    //writeTextElement( "login", pT->mLogin );
    //writeTextElement( "pass", pT->mPass );
    writeTextElement( "url", pT->mUrl );
    writeTextElement( "port", QString::number(pT->mPort) );
    writeTextElement( "borderTopHeight", QString::number(pT->mBorderTopHeight) );
    writeTextElement( "borderBottomHeight", QString::number(pT->mBorderBottomHeight) );
    writeTextElement( "borderLeftWidth", QString::number(pT->mBorderLeftWidth) );
    writeTextElement( "borderRightWidth", QString::number(pT->mBorderRightWidth) );
    writeTextElement( "wrapAt", QString::number(pT->mWrapAt) );
    writeTextElement( "wrapIndentCount", QString::number(pT->mWrapIndentCount) );
    writeTextElement( "commandSeperator", pT->mCommandSeperator );
    writeTextElement( "mFgColor", pT->mFgColor.name() );
    writeTextElement( "mBgColor", pT->mBgColor.name() );
    writeTextElement( "mCommandFgColor", pT->mCommandFgColor.name() );
    writeTextElement( "mCommandBgColor", pT->mCommandBgColor.name() );
    writeTextElement( "mBlack", pT->mBlack.name() );
    writeTextElement( "mLightBlack", pT->mLightBlack.name() );
    writeTextElement( "mRed", pT->mRed.name() );
    writeTextElement( "mLightRed", pT->mLightRed.name() );
    writeTextElement( "mBlue", pT->mBlue.name() );
    writeTextElement( "mLightBlue", pT->mLightBlue.name() );
    writeTextElement( "mGreen", pT->mGreen.name() );
    writeTextElement( "mLightGreen", pT->mLightGreen.name() );
    writeTextElement( "mYellow", pT->mYellow.name() );
    writeTextElement( "mLightYellow", pT->mLightYellow.name() );
    writeTextElement( "mCyan", pT->mCyan.name() );
    writeTextElement( "mLightCyan", pT->mLightCyan.name() );
    writeTextElement( "mMagenta", pT->mMagenta.name() );
    writeTextElement( "mLightMagenta", pT->mLightMagenta.name() );
    writeTextElement( "mWhite", pT->mWhite.name() );
    writeTextElement( "mLightWhite", pT->mLightWhite.name() );
    writeTextElement( "mDisplayFont", pT->mDisplayFont.toString() );
    writeTextElement( "mCommandLineFont", pT->mCommandLineFont.toString() );
    writeTextElement( "mCommandSeparator", pT->mCommandSeparator );
    writeTextElement( "commandLineMinimumHeight", QString::number(pT->commandLineMinimumHeight) );

    writeTextElement( "mFgColor2", pT->mFgColor_2.name() );
    writeTextElement( "mBgColor2", pT->mBgColor_2.name() );
    writeTextElement( "mBlack2", pT->mBlack_2.name() );
    writeTextElement( "mLightBlack2", pT->mLightBlack_2.name() );
    writeTextElement( "mRed2", pT->mRed_2.name() );
    writeTextElement( "mLightRed2", pT->mLightRed_2.name() );
    writeTextElement( "mBlue2", pT->mBlue_2.name() );
    writeTextElement( "mLightBlue2", pT->mLightBlue_2.name() );
    writeTextElement( "mGreen2", pT->mGreen_2.name() );
    writeTextElement( "mLightGreen2", pT->mLightGreen_2.name() );
    writeTextElement( "mYellow2", pT->mYellow_2.name() );
    writeTextElement( "mLightYellow2", pT->mLightYellow_2.name() );
    writeTextElement( "mCyan2", pT->mCyan_2.name() );
    writeTextElement( "mLightCyan2", pT->mLightCyan_2.name() );
    writeTextElement( "mMagenta2", pT->mMagenta_2.name() );
    writeTextElement( "mLightMagenta2", pT->mLightMagenta_2.name() );
    writeTextElement( "mWhite2", pT->mWhite_2.name() );
    writeTextElement( "mLightWhite2", pT->mLightWhite_2.name() );
    writeTextElement( "mSpellDic", pT->mSpellDic );
    writeEndElement(); // end Host tag
    writeEndElement(); // end HostPackage tag

    writeStartElement( "TriggerPackage" );
    bool ret = true;
    typedef list<TTrigger *>::const_iterator ItTriggerUnit;
    for( ItTriggerUnit it1 = pT->mTriggerUnit.mTriggerRootNodeList.begin(); it1 != pT->mTriggerUnit.mTriggerRootNodeList.end(); it1++)
    {
        TTrigger * pChildTrigger = *it1;
        if( ! pChildTrigger ) continue;
        if( ! pChildTrigger->isTempTrigger() )
        {
            ret = writeTrigger( pChildTrigger );
        }
    }
    writeEndElement(); //end trigger package tag

    writeStartElement("TimerPackage");
    typedef list<TTimer *>::const_iterator ItTimerUnit;
    for( ItTimerUnit it2 = pT->mTimerUnit.mTimerRootNodeList.begin(); it2 != pT->mTimerUnit.mTimerRootNodeList.end(); it2++)
    {
        TTimer * pChildTimer = *it2;
        if( ! pChildTimer->isTempTimer() )
        {
            ret = writeTimer( pChildTimer );
        }
    }
    writeEndElement();

    writeStartElement("AliasPackage");
    typedef list<TAlias *>::const_iterator ItAliasUnit;
    for( ItAliasUnit it3 = pT->mAliasUnit.mAliasRootNodeList.begin(); it3 != pT->mAliasUnit.mAliasRootNodeList.end(); it3++)
    {
        TAlias * pChildAlias = *it3;
        if( ! pChildAlias->isTempAlias() )
        {
            ret = writeAlias( pChildAlias );
        }
    }
    writeEndElement();

    writeStartElement("ActionPackage");
    typedef list<TAction *>::const_iterator ItActionUnit;
    for( ItActionUnit it4 = pT->mActionUnit.mActionRootNodeList.begin(); it4 != pT->mActionUnit.mActionRootNodeList.end(); it4++)
    {
        TAction * pChildAction = *it4;
        ret = writeAction( pChildAction );
    }
    writeEndElement();

    writeStartElement("ScriptPackage");
    typedef list<TScript *>::const_iterator ItScriptUnit;
    for( ItScriptUnit it5 = pT->mScriptUnit.mScriptRootNodeList.begin(); it5 != pT->mScriptUnit.mScriptRootNodeList.end(); it5++)
    {
        TScript * pChildScript = *it5;
        ret = writeScript( pChildScript );
    }
    writeEndElement();

    writeStartElement("KeyPackage");
    typedef list<TKey *>::const_iterator ItKeyUnit;
    for( ItKeyUnit it6 = pT->mKeyUnit.mKeyRootNodeList.begin(); it6 != pT->mKeyUnit.mKeyRootNodeList.end(); it6++)
    {
        TKey * pChildKey = *it6;
        ret = writeKey( pChildKey );
    }
    writeEndElement();

    return ret;
}

bool XMLexport::exportGenericPackage( QIODevice * device )
{
    setDevice(device);

    writeStartDocument();
    writeDTD("<!DOCTYPE MudletPackage>");

    writeStartElement( "MudletPackage" );
    writeAttribute("version", "1.0");

    writeGenericPackage( mpHost );

    writeEndElement();//MudletPackage
    writeEndDocument();
    return true;
}

bool XMLexport::writeGenericPackage( Host * pT )
{
    writeStartElement( "TriggerPackage" );
    bool ret = true;
    typedef list<TTrigger *>::const_iterator ItTriggerUnit;
    for( ItTriggerUnit it1 = pT->mTriggerUnit.mTriggerRootNodeList.begin(); it1 != pT->mTriggerUnit.mTriggerRootNodeList.end(); it1++)
    {
        TTrigger * pChildTrigger = *it1;
        if( ! pChildTrigger ) continue;
        if( ! pChildTrigger->isTempTrigger() )
        {
            ret = writeTrigger( pChildTrigger );
        }
    }
    writeEndElement(); //end trigger package tag

    writeStartElement("TimerPackage");
    typedef list<TTimer *>::const_iterator ItTimerUnit;
    for( ItTimerUnit it2 = pT->mTimerUnit.mTimerRootNodeList.begin(); it2 != pT->mTimerUnit.mTimerRootNodeList.end(); it2++)
    {
        TTimer * pChildTimer = *it2;
        if( ! pChildTimer->isTempTimer() )
        {
            ret = writeTimer( pChildTimer );
        }
    }
    writeEndElement();

    writeStartElement("AliasPackage");
    typedef list<TAlias *>::const_iterator ItAliasUnit;
    for( ItAliasUnit it3 = pT->mAliasUnit.mAliasRootNodeList.begin(); it3 != pT->mAliasUnit.mAliasRootNodeList.end(); it3++)
    {
        TAlias * pChildAlias = *it3;
        if( ! pChildAlias->isTempAlias() )
        {
            ret = writeAlias( pChildAlias );
        }
    }
    writeEndElement();

    writeStartElement("ActionPackage");
    typedef list<TAction *>::const_iterator ItActionUnit;
    for( ItActionUnit it4 = pT->mActionUnit.mActionRootNodeList.begin(); it4 != pT->mActionUnit.mActionRootNodeList.end(); it4++)
    {
        TAction * pChildAction = *it4;
        ret = writeAction( pChildAction );
    }
    writeEndElement();

    writeStartElement("ScriptPackage");
    typedef list<TScript *>::const_iterator ItScriptUnit;
    for( ItScriptUnit it5 = pT->mScriptUnit.mScriptRootNodeList.begin(); it5 != pT->mScriptUnit.mScriptRootNodeList.end(); it5++)
    {
        TScript * pChildScript = *it5;
        ret = writeScript( pChildScript );
    }
    writeEndElement();

    writeStartElement("KeyPackage");
    typedef list<TKey *>::const_iterator ItKeyUnit;
    for( ItKeyUnit it6 = pT->mKeyUnit.mKeyRootNodeList.begin(); it6 != pT->mKeyUnit.mKeyRootNodeList.end(); it6++)
    {
        TKey * pChildKey = *it6;
        ret = writeKey( pChildKey );
    }
    writeEndElement();

    return ret;
}



bool XMLexport::exportTrigger( QIODevice * device )
{
    setDevice(device);

    writeStartDocument();
    writeDTD("<!DOCTYPE MudletPackage>");

    writeStartElement( "MudletPackage" );
    writeAttribute("version", "1.0");

    writeStartElement( "TriggerPackage" );
    writeTrigger( mpTrigger );
    writeEndElement();//TriggerPackage

    writeEndElement();//MudletPackage
    writeEndDocument();
    return true;
}


bool XMLexport::writeTrigger( TTrigger * pT )
{
    QString tag;
    if( pT->mIsFolder )
    {
        tag = "TriggerGroup";
    }
    else
    {
        tag = "Trigger";
    }
    writeStartElement( tag );
    writeAttribute( "isActive", pT->shouldBeActive() ? "yes" : "no" );
    writeAttribute( "isFolder", pT->mIsFolder ? "yes" : "no" );
    writeAttribute( "isTempTrigger", pT->mIsTempTrigger ? "yes" : "no" );
    writeAttribute( "isMultiline", pT->mIsMultiline ? "yes" : "no" );
    writeAttribute( "isPerlSlashGOption", pT->mPerlSlashGOption ? "yes" : "no" );
    writeAttribute( "isColorizerTrigger", pT->mIsColorizerTrigger ? "yes" : "no" );
    writeAttribute( "isFilterTrigger", pT->mFilterTrigger ? "yes" : "no" );
    writeAttribute( "isSoundTrigger", pT->mSoundTrigger ? "yes" : "no" );
    writeAttribute( "isColorTrigger", pT->mColorTrigger ? "yes" : "no" );
    writeAttribute( "isColorTriggerFg", pT->mColorTriggerFg ? "yes" : "no" );
    writeAttribute( "isColorTriggerBg", pT->mColorTriggerBg ? "yes" : "no" );


    writeTextElement( "name", pT->mName );
    writeTextElement( "script", pT->mScript );
    writeTextElement( "triggerType", QString::number( pT->mTriggerType ) );
    writeTextElement( "conditonLineDelta", QString::number( pT->mConditionLineDelta ) );
    writeTextElement( "mStayOpen", QString::number( pT->mStayOpen ) );
    writeTextElement( "mCommand", pT->mCommand );
    writeTextElement( "mFgColor", pT->mFgColor.name() );
    writeTextElement( "mBgColor", pT->mBgColor.name() );
    writeTextElement( "mSoundFile", pT->mSoundFile );
    writeTextElement( "colorTriggerFgColor", pT->mColorTriggerFgColor.name() );
    writeTextElement( "colorTriggerBgColor", pT->mColorTriggerBgColor.name() );

    writeStartElement( "regexCodeList" );
    for( int i=0; i<pT->mRegexCodeList.size(); i++ )
    {
        writeTextElement( "string", pT->mRegexCodeList[i] );
    }
    writeEndElement();

    writeStartElement( "regexCodePropertyList" );
    for( int i=0; i<pT->mRegexCodePropertyList.size(); i++ )
    {
        writeTextElement( "integer", QString::number( pT->mRegexCodePropertyList[i] ) );
    }
    writeEndElement();
    typedef list<TTrigger *>::const_iterator I;
    for( I it = pT->mpMyChildrenList->begin(); it != pT->mpMyChildrenList->end(); it++)
    {
        TTrigger * pChild = *it;
        writeTrigger( pChild );
    }
    writeEndElement();

    return true;
}


bool XMLexport::exportAlias( QIODevice * device )
{
    setDevice(device);

    writeStartDocument();
    writeDTD("<!DOCTYPE MudletPackage>");

    writeStartElement( "MudletPackage" );
    writeAttribute("version", "1.0");

    writeStartElement( "AliasPackage" );
    writeAlias( mpAlias );
    writeEndElement();

    writeEndElement();//MudletPackage
    writeEndDocument();
    return true;
}

bool XMLexport::writeAlias( TAlias * pT )
{
    QString tag;
    if( pT->mIsFolder )
    {
        tag = "AliasGroup";
    }
    else
    {
        tag = "Alias";
    }

    writeStartElement( tag );

    writeAttribute( "isActive", pT->shouldBeActive() ? "yes" : "no" );
    writeAttribute( "isFolder", pT->mIsFolder ? "yes" : "no" );

    writeTextElement( "name", pT->mName );
    writeTextElement( "script", pT->mScript );
    writeTextElement( "command", pT->mCommand );
    writeTextElement( "regex", pT->mRegexCode );

    typedef list<TAlias *>::const_iterator I;
    for( I it = pT->mpMyChildrenList->begin(); it != pT->mpMyChildrenList->end(); it++)
    {
        TAlias * pChild = *it;
        writeAlias( pChild );
    }
    writeEndElement();

    return true;
}

bool XMLexport::exportAction( QIODevice * device )
{
    setDevice(device);

    writeStartDocument();
    writeDTD("<!DOCTYPE MudletPackage>");

    writeStartElement( "MudletPackage" );
    writeAttribute("version", "1.0");

    writeStartElement( "ActionPackage" );
    writeAction( mpAction );
    writeEndElement();

    writeEndElement();//MudletPackage
    writeEndDocument();
    return true;
}

bool XMLexport::writeAction( TAction * pT )
{
    QString tag;
    if( pT->mIsFolder )
    {
        tag = "ActionGroup";
    }
    else
    {
        tag = "Action";
    }

    writeStartElement( tag );

    writeAttribute( "isActive", pT->shouldBeActive() ? "yes" : "no" );
    writeAttribute( "isFolder", pT->mIsFolder ? "yes" : "no" );
    writeAttribute( "isPushButton", pT->mIsPushDownButton ? "yes" : "no" );
    writeAttribute( "isFlatButton", pT->mButtonFlat ? "yes" : "no" );
    writeAttribute( "useCustomLayout", pT->mUseCustomLayout ? "yes" : "no" );

    writeTextElement( "name", pT->mName );
    writeTextElement( "script", pT->mScript );
    writeTextElement( "css", pT->css );
    writeTextElement( "commandButtonUp", pT->mCommandButtonUp );
    writeTextElement( "commandButtonDown", pT->mCommandButtonDown );
    writeTextElement( "icon", pT->mIcon );
    writeTextElement( "orientation", QString::number(pT->mOrientation) );
    writeTextElement( "location", QString::number(pT->mLocation) );
    writeTextElement( "posX", QString::number(pT->mPosX) );
    writeTextElement( "posY", QString::number(pT->mPosY) );
    writeTextElement( "mButtonState", QString::number(pT->mButtonState) );
    writeTextElement( "sizeX", QString::number(pT->mSizeX) );
    writeTextElement( "sizeY", QString::number(pT->mSizeY) );
    writeTextElement( "buttonColumn", QString::number(pT->mButtonColumns) );
    writeTextElement( "buttonRotation", QString::number(pT->mButtonRotation) );
    writeTextElement( "buttonColor", pT->mButtonColor.name() );

    typedef list<TAction *>::const_iterator I;
    for( I it = pT->mpMyChildrenList->begin(); it != pT->mpMyChildrenList->end(); it++)
    {
        TAction * pChild = *it;
        writeAction( pChild );
    }
    writeEndElement();

    return true;
}

bool XMLexport::exportTimer( QIODevice * device )
{

    setDevice(device);

    writeStartDocument();
    writeDTD("<!DOCTYPE MudletPackage>");

    writeStartElement( "MudletPackage" );
    writeAttribute("version", "1.0");

    writeStartElement( "TimerPackage" );
    writeTimer( mpTimer );
    writeEndElement();

    writeEndElement();//MudletPackage
    writeEndDocument();
    return true;
}

bool XMLexport::writeTimer( TTimer * pT )
{
    QString tag;
    if( pT->mIsFolder )
    {
        tag = "TimerGroup";
    }
    else
    {
        tag = "Timer";
    }

    writeStartElement( tag );

    writeAttribute( "isActive", pT->shouldBeActive() ? "yes" : "no" );
    writeAttribute( "isFolder", pT->mIsFolder ? "yes" : "no" );
    writeAttribute( "isTempTimer", pT->mIsTempTimer ? "yes" : "no" );

    writeTextElement( "name", pT->mName );
    writeTextElement( "script", pT->mScript );
    writeTextElement( "command", pT->mCommand );
    writeTextElement( "time", pT->mTime.toString( "hh:mm:ss.zzz" ) );

    typedef list<TTimer *>::const_iterator I;
    for( I it = pT->mpMyChildrenList->begin(); it != pT->mpMyChildrenList->end(); it++)
    {
        TTimer * pChild = *it;
        writeTimer( pChild );
    }
    writeEndElement();

    return true;
}


bool XMLexport::exportScript( QIODevice * device )
{
    setDevice(device);

    writeStartDocument();
    writeDTD("<!DOCTYPE MudletPackage>");

    writeStartElement( "MudletPackage" );
    writeAttribute("version", "1.0");

    writeStartElement( "ScriptPackage" );
    writeScript( mpScript );
    writeEndElement();

    writeEndElement();//MudletPackage
    writeEndDocument();
    return true;
}

bool XMLexport::writeScript( TScript * pT )
{
    QString tag;
    if( pT->mIsFolder )
    {
        tag = "ScriptGroup";
    }
    else
    {
        tag = "Script";
    }

    writeStartElement( tag );

    writeAttribute( "isActive", pT->shouldBeActive() ? "yes" : "no" );
    writeAttribute( "isFolder", pT->mIsFolder ? "yes" : "no" );

    writeTextElement( "name", pT->mName );
    writeTextElement( "script", pT->mScript );

    writeStartElement( "eventHandlerList" );
    for( int i=0; i<pT->mEventHandlerList.size(); i++ )
    {
        writeTextElement( "string", pT->mEventHandlerList[i] );
    }
    writeEndElement();

    typedef list<TScript *>::const_iterator I;
    for( I it = pT->mpMyChildrenList->begin(); it != pT->mpMyChildrenList->end(); it++)
    {
        TScript * pChild = *it;
        writeScript( pChild );
    }
    writeEndElement();

    return true;
}


bool XMLexport::exportKey( QIODevice * device )
{
    setDevice(device);

    writeStartDocument();
    writeDTD("<!DOCTYPE MudletPackage>");

    writeStartElement( "MudletPackage" );
    writeAttribute("version", "1.0");

    writeStartElement( "KeyPackage" );
    writeKey( mpKey );
    writeEndElement();

    writeEndElement();//MudletPackage
    writeEndDocument();
    return true;
}

bool XMLexport::writeKey( TKey * pT )
{
    QString tag;
    if( pT->mIsFolder )
    {
        tag = "KeyGroup";
    }
    else
    {
        tag = "Key";
    }

    writeStartElement( tag );

    writeAttribute( "isActive", pT->shouldBeActive() ? "yes" : "no" );
    writeAttribute( "isFolder", pT->mIsFolder ? "yes" : "no" );

    writeTextElement( "name", pT->mName );
    writeTextElement( "script", pT->mScript );
    writeTextElement( "command", pT->mCommand );
    writeTextElement( "keyCode", QString::number( pT->mKeyCode ) );
    writeTextElement( "keyModifier", QString::number( pT->mKeyModifier ) );

    typedef list<TKey *>::const_iterator I;
    for( I it = pT->mpMyChildrenList->begin(); it != pT->mpMyChildrenList->end(); it++)
    {
        TKey * pChild = *it;
        writeKey( pChild );
    }
    writeEndElement();

    return true;
}

