/*
 *   Written by Bradley Broom (2002).
 *
 *   Copyright (c) 2002 Bradley Broom
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <math.h>
#include <string.h>
#include "MRI.h"
#include "vmedian.h"

struct LabToneCurveData {
	struct link *next;
	int	width;
	int	height;
	int	mask;
	MRI_SampledCurve  *crv;
};

static void
LabToneCurveStart (void *private, int width, int height, int freedata)
{
	struct LabToneCurveData *wd = private;

	wd->width = width;
	wd->height = height;
	(*wd->next->start) (wd->next->private, width, height, freedata);
}

static inline
void
scaleFPixel (double *p, struct LabToneCurveData *wd)
{
	*p = MRI_SampleCurveMapValue (wd->crv, *p/100.0) * 100.0;
}

static void
LabToneCurveRow (void *private, void *data)
{
	struct LabToneCurveData *wd = private;
	struct MRI_ScanLine *fp = data;
	double *R = fp->R;
	double *G = fp->G;
	double *B = fp->B;
	int x;

	for (x = 0; x < wd->width; x++) {
		if (wd->mask & TONE_R)
			scaleFPixel (&R[x], wd);
		if (wd->mask & TONE_G)
			scaleFPixel (&G[x], wd);
		if (wd->mask & TONE_B)
			scaleFPixel (&B[x], wd);
	}
	(*wd->next->row) (wd->next->private, fp);
}

static void
LabToneCurveClose (void *private)
{
	struct LabToneCurveData *wd = private;

	(*wd->next->close) (wd->next->private);
	free (wd->next);
	free (wd);
}

struct link *
MRI_GenToneCurver (MRI_SampledCurve *crv, struct link *next, int LabMode)
{
	struct LabToneCurveData *wd = malloc (sizeof (struct LabToneCurveData));
	struct link *ep = malloc (sizeof (*ep));
	if (wd == (struct LabToneCurveData *)0 || ep == (struct link *)0) {
		fprintf (stderr, "Error: unable to allocate memory\n");
		exit (1);
	}
	ep->start = LabToneCurveStart;
	ep->row = LabToneCurveRow;
	ep->close = LabToneCurveClose;
	ep->private = wd;
	wd->next = next;
	wd->crv = crv;
	wd->mask = LabMode ? TONE_R : TONE_RGB;

	return ep;
}
