/*
 *   Written by Bradley Broom (2002).
 *
 *   Copyright (c) 2002,2003 Bradley Broom
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef _MRI_H
#define _MRI_H

#include <stdlib.h>
#include <stdio.h>
#include <glib/gmacros.h>
#include "MRI_Types.h"
#include "MRI_SampledCurves.h"

#define	TONE_R	0x01
#define	TONE_G  0x02
#define TONE_B  0x04
#define TONE_RGB  0x07

extern MRI  *MRI_New (const void *);
extern void MRI_Allocate (MRI *);
extern void MRI_Free (MRI *);
extern void MRI_ApplyNoiseMap (MRI *mri, char *filename);

extern void MRI_AdjustBalanceLuminance (MRI *mri, MRI_balance *balanceSpec, double *luma);
extern void MRI_SetBalance (MRI *, MRI_balance);
extern void MRI_SetDFactor (MRI *, int);
extern struct MRI_ScanLine *MRI_NewScanLine (int type, int width);
extern void MRI_FreeScanLine (struct MRI_ScanLine *);
extern struct MRI_ScanLine *MRI_GetRow (MRI *mri, int y, int xoff, int width);
extern struct MRI_ScanLine *MRI_GetCol (MRI *mri, int x, int yoff, int height);

extern const char *MRI_GetCameraName (const MRI *);
extern int MRI_GetFlash (const MRI *);
extern int MRI_GetWidth (const MRI *);
extern int MRI_GetHeight (const MRI *);
extern void MRI_ClearBalance (MRI *mri, const char *name);
extern int MRI_GetBalance (MRI_balance *, MRI *, const char *name);
extern int MRI_GetBalanceRegion (MRI_balance *, MRI *, const char *name, MRI_Region *region);
extern MRI_balance MRI_EstimateWB (MRI *, MRI_Region *);
extern MRI_balance MRI_GrayWorldWB (MRI *, MRI_Region *);
extern MRI_balance MRI_BinGrayWorldWB (MRI *, MRI_Region *);
extern const char *MRI_GetTimestamp (const MRI *);
extern double MRI_GetShutter (const MRI *);
extern double MRI_GetAperture (const MRI *);
extern double MRI_GetISO (const MRI *);
extern double MRI_GetFocusLen (const MRI *);
extern double MRI_GetFocalLen (const MRI *);
extern int MRI_GetFocusMode (const MRI *);
extern cmsCIEXYZ * MRI_GetWhitePoint (const MRI *);
extern cmsHPROFILE MRI_GetNativeProfile (const struct _MRI *);
extern void MRI_ConvertScanLineToLAB (const struct _MRI *, struct MRI_ScanLine *);

extern MRI_Link * MRI_GenFtSConverter ( MRI_Link *, const MRI *, int );
extern MRI_Link * GenMRIStFConverter ( MRI_Link *, MRI_balance , int );
extern MRI_Link * GenInterpBilinearRGB (MRI_Link *, int );
extern MRI_Link * GenInterpMedianGBilinearRB (MRI_Link *, int );
extern MRI_Link * GenInterpMedianGHueRBilinearB (MRI_Link *, int );

extern MRI_Link * MRI_GenInterpBilinearRGB (MRI_Link *, int );
extern MRI_Link * MRI_GenInterpMedianGBilinearRB (MRI_Link *, int );
extern MRI_Link * MRI_GenInterpMedianGHueRBilinearB (MRI_Link *, int );

extern MRI_Link * MRI_GenLimitMasker (MRI_Link *next);
extern MRI_Link * MRI_GenColorBalancer (MRI_balance , MRI_Link *);
extern MRI_Link * MRI_GenLimitCorrecter (MRI_balance, MRI_Link *, int redGreen);
extern MRI_Link * MRI_GenToneCurver (MRI_SampledCurve *,  MRI_Link *, int LabMode);
extern MRI_Link * GenVMedianFilter (MRI_Link *, int, double);
extern MRI_Link * GenMedianFilter (MRI_Link *);
extern MRI_Link * MRI_GenMedianFilter (MRI_Link *);
extern MRI_Link * GenFMedianFilter (MRI_Link *next, int mask);

#define MRI_PSEUDO_ORIG 0
#define MRI_PSEUDO_SMOOTH 1
extern MRI_Link * MRI_GenPseudoPixelExpander (MRI_Link *next, int RGFirst, int type);
extern MRI_Link * MRI_GenPseudoPixelExpanderFloat (MRI_Link *next, int RGFirst, int type);
extern MRI_Link * GenVMedianCondenser (double vtol, MRI_Link *next);

extern MRI_Link * MRI_GenColorSpacer (MRI *, const char *, const char *, int , MRI_Link *);
extern MRI_Link * MRI_GenSubsampler (int, int , MRI_Link *);
extern MRI_Link * GenMRIEnhance (double , const char *, MRI_Link *);
extern MRI_Link * MRI_GenConvolver (int , double, double, int, double [], MRI_Link *);
extern MRI_Link * MRI_GenDarkFieldFilter (MRI *darkField, int rotate, MRI_balance bal, int dFactor, MRI *mp, MRI_Link *next);
extern MRI_Link * MRI_GenStuckPixelFilter (const char *filename, int rotate, MRI *mp, MRI_Link *next);

extern MRI_Link * GenOutputProfileConverter (MRI *, MRI_Link *);

extern MRI_Link * MRI_GenImageImprover (MRI_Link *, const MRI_ImproverOptions *, MRI_ImproverInfo *);
extern MRI_Link * MRI_GenBayerInterpolator (MRI *, MRI_Link *, const MRI_InterpolatorOptions *, FILE *tracefd);
extern MRI_Link * MRI_GenReverser (MRI_Link *next);
extern MRI_Link * MRI_GenContrastAdjuster (double brightness, double lumascale, double contrast, double shadows, double saturation, MRI_Link *next);
extern MRI_Link * MRI_GenHistogramCounter (int N, int *counts, double *Lmin, double *Lmax, MRI_Link *next);

extern MRI_Link * MRI_GenPPMWriter (int outputBits, int reversed, FILE *f);
extern MRI_Link * MRI_GenPPMWriterTee (MRI_Link *, int outputBits, int reversed, FILE *f);
extern MRI_Link * MRI_GenXVMiniWriter (MRI *, int reversed, FILE *f);

extern void InitColorProfiles (MRI *, int, char *, char *);
extern int Reversed (int);
extern void FreeProfileFiles (void);

extern int MRI_RGFirst (const MRI *, int);
extern void MRI_ProcessImage (MRI_Link *, MRI *, int);
extern void MRI_ProcessImageRegion (MRI_Link *, MRI *, int, MRI_Region *);
extern void MRI_FlushPipeline (MRI_Link *);

typedef struct _processIterator MRI_ProcessIterator;
extern MRI_ProcessIterator * MRI_NewProcessIterator (struct link *head, MRI *mri, int rotate, MRI_Region *r);
extern int MRI_DoProcessIterator (MRI_ProcessIterator *pip);
extern void MRI_FreeProcessIterator (MRI_ProcessIterator *pip);

#endif
