#include <stdio.h>
#include <MRI.h>
#include "FindFile.h"
#include "FindBalanceSpec.h"

static int
DecodeBalance (MRI_balance *bp, const char *spec)
{
	int rgain, ggain, bgain;
	if ( sscanf (spec, "%d:%d:%d", &rgain, &ggain, &bgain) != 3 )
		return 0;

	if (rgain < 0 || ggain < 0 || bgain < 0)
		return 0;

	bp->rgain = rgain;
	bp->ggain = ggain;
	bp->bgain = bgain;
	return 1;
}

int
GetBalanceSpec (MRI_balance *balanceSpec, const char *balance, const char *colorMapPath)
{
	char	*balanceFile;

	if ((balanceFile = FindFile (balance, colorMapPath, ".cmap")) == (char *)0) {
		if (DecodeBalance (balanceSpec, balance) == 0)
			return BALANCE_ERROR_NOTFOUND;
	}
	else {
		char	buffer[8192]; /* Assume color spec can't be this big. */
		FILE	*f = fopen (balanceFile, "r");
		char	*s;
		if (f == (FILE *)0) {
			return BALANCE_ERROR_NOTOPENED;
		}
		else {
			fgets (buffer, sizeof (buffer), f);
			fclose (f);
			if ((s = strchr (buffer, '\n')) != (char *)0) *s = '\0';
			if (DecodeBalance (balanceSpec, buffer) == 0)
				return BALANCE_ERROR_NOTPARSED;
		}
		free (balanceFile);
	}
	return 0;
}

int
FindBalanceSpec (MRI_balance *bal, char *name, char *path)
{
    int err = GetBalanceSpec (bal, name, path);

    if (err) {
	extern char *progname;
	switch (err) {
		case BALANCE_ERROR_NOTFOUND:
			fprintf (stderr, "%s: Error: cannot find/parse color balance \"%s\"\n", progname, name);
			break;
		case BALANCE_ERROR_NOTPARSED:
			fprintf (stderr, "%s: Error: cannot open color balance file for %s\n", progname, name);
			break;
		case BALANCE_ERROR_NOTOPENED:
			fprintf (stderr, "%s: Error: cannot parse color balance \"%s\"\n", progname, name);
			break;
		default:
			fprintf (stderr, "%s: Internal Error %d for balance \"%s\"\n", progname, err, name);
	}
	bal->rgain = bal->ggain = bal->bgain = 256;
    }
    return err;
}
