
#include <mrpt/core.h>

using namespace mrpt;
using namespace mrpt::utils;
using namespace mrpt::math;
using namespace std;


// return 0 if OK.
int test_compress_main(int /*argc*/,char* /*argv*/[])
{
	const size_t N = 20000;

	// Create a random "input" data vector
	vector_byte   in_data(N);
	for (size_t i=0;i<N;i++)
		in_data[i] = static_cast<uint8_t>(i);  // We need low entropy for compression to have something to do!

	// Compress it:
	vector_byte compress_data;

	cout << "[test_compress_main] Invoking compress_gz_data_block" << endl;

	if (!mrpt::compress::zip::compress_gz_data_block(in_data,compress_data)) return 1;

	cout << "Compressed gz-data: " << N << " -> " << compress_data.size() << " bytes." << endl;

	vector_byte recovered_data;
	if (!mrpt::compress::zip::decompress_gz_data_block(compress_data, recovered_data)) return 1;

	cout << "Decompressed data: " << recovered_data.size() << " bytes." << endl;

	uint8_t err = mrpt::math::sum( recovered_data - in_data );
	cout << "Erroneous bytes: " << (int)err << " bytes." << endl;

	return err==0 ?  0: 1;  // 0:OK
}

