#ifndef NEW_META_OUTPUTTER_H_
#define NEW_META_OUTPUTTER_H_

#include <string>
#include <map>

#include "Basic3DOutputter.h"
#include "BasicVolumeFormat.h"

namespace jcs {

struct NewMetaHeader;

class NewMetaOutputter : public Basic3DOutputter {

public :
	NewMetaOutputter();
	virtual int ConvertSeries(SeriesHandler* handler);
	
	bool SaveHeaderOnly() const { return saveHeaderOnly; }
	void SetSaveHeader(bool value);
	std::vector<std::string> fields;

	void SetOption(const std::string& name, bool value);


protected:
	virtual BasicVolumeFormat* GetOutputVolume(const char* file);

//	virtual Basic3DHeader* GetHeader(SeriesHandler* handler);

private:
	static Options CreateOptions();
	bool saveHeaderOnly;



};

template <class T>
class MetaConversion: public Basic3DConversion <T> {

public:
	MetaConversion(Basic3DOutputter* outputter, SeriesHandler* handler);
	~MetaConversion();

	NewMetaHeader* GetHeader() { return mHeader; }

	void Convert();

protected:
	virtual void GetHeaderForSeries();
	virtual void CompleteHeaderForVolume(std::pair<VolId, Volume<T> > volPair);

private:
	NewMetaHeader* mHeader;

};

}

#endif
