/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog2;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import logformat.clog2.MixedDataInputStream;
import logformat.clog2.Preamble;
import logformat.clog2.RecDefEvent;
import logformat.clog2.RecDefState;

public class InputLog {
    private static final int INPUT_STREAM_BUFSIZE = 1024;
    private String filename;
    private DataInputStream main_ins;
    private Preamble preamble;
    private byte[] buffer;

    public InputLog(String pathname) {
        this.filename = pathname;
        FileInputStream fins = null;
        try {
            fins = new FileInputStream(this.filename);
        }
        catch (FileNotFoundException ferr) {
            ferr.printStackTrace();
            System.exit(0);
        }
        BufferedInputStream buf_ins = new BufferedInputStream(fins, 1024);
        this.main_ins = new DataInputStream(buf_ins);
        this.preamble = new Preamble();
        this.preamble.readFromDataStream(this.main_ins);
        if (!this.preamble.isVersionMatched()) {
            if (!this.preamble.isVersionCompatible()) {
                System.err.println("Error: CLOG versions mismatched !\n\tThe input logfile version is " + this.preamble.getVersionString() + "\n" + "\t" + "But this tool is of version " + "CLOG-02.44");
                System.exit(1);
            } else {
                System.err.println("Warning: CLOG versions compatible !\n\tThe input logfile version is " + this.preamble.getVersionString() + "\n" + "\t" + "But this tool is of version " + "CLOG-02.44");
            }
        }
        if (!this.preamble.isBigEndian()) {
            System.err.println("Error: input logfile is little-endian!");
            System.exit(1);
        }
        this.buffer = null;
    }

    public String getFileName() {
        return this.filename;
    }

    public Preamble getPreamble() {
        return this.preamble;
    }

    public MixedDataInputStream getBlockStream() {
        if (this.main_ins == null) {
            System.err.println("Error: input_stream.main_ins == null !!");
            return null;
        }
        if (this.buffer == null) {
            this.buffer = new byte[this.preamble.getBlockSize()];
        }
        try {
            this.main_ins.readFully(this.buffer);
        }
        catch (EOFException eof) {
            return null;
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
            return null;
        }
        return new MixedDataInputStream(new ByteArrayInputStream(this.buffer));
    }

    public List getKnownUndefinedInitedStateDefs() {
        return RecDefState.getUndefinedInitedStateDefs(this.preamble.getKnownEventIDStart(), this.preamble.getKnownStateIDCount());
    }

    public List getUserUndefinedInitedStateDefs() {
        return RecDefState.getUndefinedInitedStateDefs(this.preamble.getUserEventIDStart(), this.preamble.getUserStateIDCount());
    }

    public List getKnownUndefinedInitedEventDefs() {
        return RecDefEvent.getUndefinedInitedEventDefs(this.preamble.getKnownSoloEventIDStart(), this.preamble.getKnownSoloEventIDCount());
    }

    public List getUserUndefinedInitedEventDefs() {
        return RecDefEvent.getUndefinedInitedEventDefs(this.preamble.getUserSoloEventIDStart(), this.preamble.getUserSoloEventIDCount());
    }

    public void close() {
        try {
            this.main_ins.close();
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

