/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import viewer.zoomable.Debug;
import viewer.zoomable.named_vector;

public class YaxisTree
extends JTree {
    private static final long serialVersionUID = 3200L;
    private DefaultMutableTreeNode tree_root;
    private List[] leveled_paths;
    private int max_level;
    private int next_expanding_level;
    private List cut_paste_buf;
    private int buf_level;

    public YaxisTree(DefaultMutableTreeNode in_root) {
        super(in_root);
        this.tree_root = in_root;
        super.putClientProperty("JTree.lineStyle", "Angled");
    }

    private void getAllLeavesForNode(named_vector nvtr, DefaultMutableTreeNode node) {
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            if (child.isLeaf()) {
                nvtr.add(child.getUserObject());
                continue;
            }
            this.getAllLeavesForNode(nvtr, child);
        }
    }

    public named_vector getNamedVtr(TreePath node_path) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)node_path.getLastPathComponent();
        named_vector nvtr = new named_vector(node.toString());
        if (!super.isExpanded(node_path)) {
            this.getAllLeavesForNode(nvtr, node);
        }
        return nvtr;
    }

    public void init() {
        this.update_leveled_paths();
        super.setEditable(true);
    }

    public void update_leveled_paths() {
        TreePath path;
        int ilevel;
        this.max_level = this.tree_root.getLastLeaf().getLevel();
        if (Debug.isActive()) {
            Debug.println("tree_root(" + this.tree_root + ").level=" + this.tree_root.getLevel());
            Debug.println("last_leaf(" + this.tree_root.getLastLeaf() + ").level=" + this.max_level);
        }
        this.leveled_paths = new ArrayList[this.max_level + 1];
        this.leveled_paths[0] = new ArrayList(1);
        for (ilevel = 1; ilevel <= this.max_level; ++ilevel) {
            this.leveled_paths[ilevel] = new ArrayList();
        }
        Enumeration<TreeNode> nodes = this.tree_root.breadthFirstEnumeration();
        if (nodes != null) {
            while (nodes.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
                path = new TreePath(node.getPath());
                this.leveled_paths[node.getLevel()].add(path);
            }
        }
        boolean isAllExpanded = true;
        this.next_expanding_level = ilevel = 0;
        while (ilevel < this.max_level && isAllExpanded) {
            Iterator paths = this.leveled_paths[ilevel].iterator();
            while (paths.hasNext() && isAllExpanded) {
                path = (TreePath)paths.next();
                isAllExpanded = isAllExpanded && super.isExpanded(path);
            }
            ++ilevel;
        }
        this.next_expanding_level = ilevel > this.max_level ? this.max_level : ilevel - 1;
    }

    public boolean isLevelExpandable() {
        return this.next_expanding_level < this.max_level;
    }

    public void expandLevel() {
        if (!this.isLevelExpandable()) {
            return;
        }
        Iterator paths = this.leveled_paths[this.next_expanding_level].iterator();
        while (paths.hasNext()) {
            TreePath path = (TreePath)paths.next();
            if (!super.isCollapsed(path)) continue;
            super.expandPath(path);
        }
        this.next_expanding_level = this.next_expanding_level < this.max_level ? ++this.next_expanding_level : this.max_level;
    }

    public boolean isLevelCollapsable() {
        int next_collapsing_level = this.next_expanding_level - 1;
        return next_collapsing_level >= 0;
    }

    public void collapseLevel() {
        if (!this.isLevelCollapsable()) {
            return;
        }
        int next_collapsing_level = this.next_expanding_level - 1;
        Iterator paths = this.leveled_paths[next_collapsing_level].iterator();
        while (paths.hasNext()) {
            TreePath path = (TreePath)paths.next();
            if (!super.isExpanded(path)) continue;
            super.collapsePath(path);
        }
        this.next_expanding_level = next_collapsing_level;
    }

    public void renewCutAndPasteBuffer() {
        this.buf_level = -1;
        if (this.cut_paste_buf != null) {
            this.cut_paste_buf.clear();
        } else {
            this.cut_paste_buf = new ArrayList();
        }
    }

    public boolean isPathLevelSameAsThatOfCutAndPasteBuffer(TreePath path) {
        return this.buf_level == this.getLastPathComponentLevel(path);
    }

    private int getLastPathComponentLevel(TreePath path) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        return node.getLevel();
    }

    public boolean isCutAndPasteBufferUniformlyLeveled(TreePath[] paths) {
        if (paths != null && paths.length > 0) {
            int ilevel = this.getLastPathComponentLevel(paths[0]);
            for (int idx = 1; idx < paths.length; ++idx) {
                if (ilevel == this.getLastPathComponentLevel(paths[idx])) continue;
                return false;
            }
            this.buf_level = ilevel;
        }
        return true;
    }

    public void addToCutAndPasteBuffer(TreePath[] paths) {
        if (this.cut_paste_buf != null) {
            for (int idx = 0; idx < paths.length; ++idx) {
                this.cut_paste_buf.add(paths[idx]);
            }
        }
    }

    public int getLevelOfCutAndPasteBuffer() {
        return this.buf_level;
    }

    public TreePath[] getFromCutAndPasteBuffer() {
        if (this.cut_paste_buf != null) {
            Object[] objs = this.cut_paste_buf.toArray();
            TreePath[] paths = new TreePath[objs.length];
            for (int idx = 0; idx < objs.length; ++idx) {
                paths[idx] = (TreePath)objs[idx];
            }
            return paths;
        }
        return null;
    }

    public void clearCutAndPasteBuffer() {
        if (this.cut_paste_buf != null) {
            this.cut_paste_buf.clear();
        }
    }
}

