/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import viewer.common.Const;
import viewer.common.LabeledTextField;
import viewer.common.Parameters;
import viewer.common.Routines;
import viewer.zoomable.Diagnosis;
import viewer.zoomable.ScaledSlider;
import viewer.zoomable.ViewportTimeYaxis;
import viewer.zoomable.YaxisTree;

public class RowAdjustments {
    private static final Font FONT = Const.FONT;
    private static final String ROW_COUNT_RESIZE = "Row";
    private static final String ROW_HEIGHT_RESIZE = "Height";
    private ViewportTimeYaxis canvas_vport;
    private YaxisTree tree_view;
    private JComboBox combo_ROW_RESIZE;
    private ScaledSlider slider_VIS_ROW_HEIGHT;
    private LabeledTextField fld_VIS_ROW_HEIGHT;
    private ScaledSlider slider_VIS_ROW_COUNT;
    private LabeledTextField fld_VIS_ROW_COUNT;
    private JButton fitall_btn;
    private JPanel combo_panel;
    private JPanel txtfld_panel;
    private JPanel slider_panel;
    private JPanel misc_panel;
    private Diagnosis debug;

    public RowAdjustments(ViewportTimeYaxis y_vport, YaxisTree y_tree) {
        this.canvas_vport = y_vport;
        this.tree_view = y_tree;
        this.debug = new Diagnosis();
        this.debug.setActive(false);
        this.combo_ROW_RESIZE = new JComboBox();
        this.combo_ROW_RESIZE.setFont(FONT);
        this.combo_ROW_RESIZE.setEditable(false);
        this.combo_ROW_RESIZE.addItem(ROW_COUNT_RESIZE);
        this.combo_ROW_RESIZE.addItem(ROW_HEIGHT_RESIZE);
        this.combo_ROW_RESIZE.setToolTipText("Display mode for row adjustment control");
        this.combo_ROW_RESIZE.addActionListener(new ResizeModeActionListener());
        this.slider_VIS_ROW_HEIGHT = new ScaledSlider(1);
        this.slider_VIS_ROW_HEIGHT.setLabelFormat("#,##0");
        this.slider_VIS_ROW_HEIGHT.setInverted(true);
        this.slider_VIS_ROW_HEIGHT.addChangeListener(new RowHeightSliderListener());
        this.fld_VIS_ROW_HEIGHT = new LabeledTextField("Row Height", "#,##0");
        this.fld_VIS_ROW_HEIGHT.setToolTipText("Row height of timeline in pixel.");
        this.fld_VIS_ROW_HEIGHT.setHorizontalAlignment(0);
        this.fld_VIS_ROW_HEIGHT.setEditable(true);
        this.fld_VIS_ROW_HEIGHT.addActionListener(new RowHeightTextListener());
        this.slider_VIS_ROW_COUNT = new ScaledSlider(1);
        this.slider_VIS_ROW_COUNT.setLabelFormat("#,##0");
        this.slider_VIS_ROW_COUNT.setInverted(false);
        this.slider_VIS_ROW_COUNT.addChangeListener(new RowCountSliderListener());
        this.fld_VIS_ROW_COUNT = new LabeledTextField("Row Count", "###0.0#");
        this.fld_VIS_ROW_COUNT.setToolTipText("Visible row count in canvas during timeline window resizing.");
        this.fld_VIS_ROW_COUNT.setHorizontalAlignment(0);
        this.fld_VIS_ROW_COUNT.setEditable(true);
        this.fld_VIS_ROW_COUNT.addActionListener(new RowCountTextListener());
        this.combo_panel = new JPanel();
        this.combo_panel.setLayout(new BoxLayout(this.combo_panel, 0));
        this.combo_panel.add(this.combo_ROW_RESIZE);
        this.txtfld_panel = new JPanel();
        this.txtfld_panel.setLayout(new BoxLayout(this.txtfld_panel, 0));
        this.txtfld_panel.setBorder(BorderFactory.createEtchedBorder());
        this.slider_panel = new JPanel();
        this.slider_panel.setLayout(new BoxLayout(this.slider_panel, 0));
        this.slider_panel.addComponentListener(new SliderComponentListener());
        this.fitall_btn = new JButton("Fit All Rows");
        this.fitall_btn.setFont(FONT);
        this.fitall_btn.setBorder(BorderFactory.createRaisedBevelBorder());
        this.fitall_btn.setToolTipText("Compute the optimal row height that fits all the rows in the Timeline canvas");
        this.fitall_btn.addActionListener(new ButtonActionListener());
        this.fitall_btn.setAlignmentX(0.0f);
        this.misc_panel = new JPanel();
        this.misc_panel.setLayout(new BoxLayout(this.misc_panel, 1));
        this.misc_panel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.misc_panel.add(this.fitall_btn);
    }

    public void initYLabelTreeSize() {
        this.tree_view.setRootVisible(Parameters.Y_AXIS_ROOT_VISIBLE);
        int avail_screen_height = (int)((float)Routines.getScreenSize().height * Parameters.SCREEN_HEIGHT_RATIO);
        int row_count = this.tree_view.getRowCount();
        int row_height = avail_screen_height / row_count;
        this.tree_view.setRowHeight(row_height);
        this.tree_view.setVisibleRowCount(row_count);
    }

    public void initSlidersAndTextFields() {
        int row_count = this.tree_view.getRowCount();
        int row_height = this.tree_view.getRowHeight();
        if (this.debug.isActive()) {
            this.debug.println("initSliders: START");
            this.debug.println("initSliders: N=" + row_count + ", h=" + row_height);
        }
        this.slider_VIS_ROW_HEIGHT.setMinLabel(0);
        this.slider_VIS_ROW_HEIGHT.setMaxLabel(row_height * row_count);
        if (row_count > 1) {
            this.slider_VIS_ROW_COUNT.setMinLabel(1);
            this.slider_VIS_ROW_COUNT.setMaxLabel(row_count);
        } else {
            this.slider_VIS_ROW_COUNT.setMinLabel(0);
            this.slider_VIS_ROW_COUNT.setMaxLabel(1);
        }
        if (Parameters.ROW_RESIZE_MODE.equals(ROW_COUNT_RESIZE)) {
            this.combo_ROW_RESIZE.setSelectedItem(ROW_COUNT_RESIZE);
            this.fld_VIS_ROW_COUNT.setDouble(row_count);
            this.fld_VIS_ROW_COUNT.fireActionPerformed();
        } else if (Parameters.ROW_RESIZE_MODE.equals(ROW_HEIGHT_RESIZE)) {
            this.combo_ROW_RESIZE.setSelectedItem(ROW_HEIGHT_RESIZE);
            this.fld_VIS_ROW_HEIGHT.setDouble(row_height);
            this.fld_VIS_ROW_HEIGHT.fireActionPerformed();
        }
        if (this.debug.isActive()) {
            this.debug.println("initSliders: END");
        }
    }

    public JPanel getComboBoxPanel() {
        return this.combo_panel;
    }

    public JPanel getTextFieldPanel() {
        return this.txtfld_panel;
    }

    public JPanel getSliderPanel() {
        return this.slider_panel;
    }

    public JPanel getMiscPanel() {
        return this.misc_panel;
    }

    private void initPanelsToRowHeightMode() {
        this.txtfld_panel.removeAll();
        this.txtfld_panel.add(this.fld_VIS_ROW_HEIGHT);
        this.txtfld_panel.revalidate();
        this.txtfld_panel.repaint();
        this.slider_panel.removeAll();
        this.slider_panel.add(this.slider_VIS_ROW_HEIGHT);
        this.slider_panel.revalidate();
        this.slider_panel.repaint();
    }

    private void initPanelsToRowCountMode() {
        this.txtfld_panel.removeAll();
        this.txtfld_panel.add(this.fld_VIS_ROW_COUNT);
        this.txtfld_panel.revalidate();
        this.txtfld_panel.repaint();
        this.slider_panel.removeAll();
        this.slider_panel.add(this.slider_VIS_ROW_COUNT);
        this.slider_panel.revalidate();
        this.slider_panel.repaint();
    }

    public void updateSlidersAfterTreeExpansion() {
        String resize_mode = (String)this.combo_ROW_RESIZE.getSelectedItem();
        if (resize_mode.equals(ROW_COUNT_RESIZE)) {
            int row_count = this.tree_view.getRowCount();
            this.slider_VIS_ROW_COUNT.setMaxLabel(row_count);
            this.fld_VIS_ROW_COUNT.fireActionPerformed();
        }
        this.fitall_btn.doClick();
    }

    private class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            double row_height = (double)RowAdjustments.this.canvas_vport.getHeight() / (double)RowAdjustments.this.tree_view.getRowCount();
            RowAdjustments.this.slider_VIS_ROW_HEIGHT.setValLabel(row_height);
            RowAdjustments.this.fld_VIS_ROW_HEIGHT.setDouble(row_height);
        }
    }

    private class RowCountTextListener
    implements ActionListener {
        private RowCountTextListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("RowCountTextListener: START");
            }
            double min_vis_row_count = RowAdjustments.this.slider_VIS_ROW_COUNT.getMinLabel();
            double max_vis_row_count = RowAdjustments.this.slider_VIS_ROW_COUNT.getMaxLabel();
            double row_height = -1.0;
            double vis_row_count = RowAdjustments.this.fld_VIS_ROW_COUNT.getDouble();
            if (vis_row_count > max_vis_row_count) {
                vis_row_count = max_vis_row_count;
                RowAdjustments.this.fld_VIS_ROW_COUNT.setDouble(vis_row_count);
            } else if (vis_row_count < min_vis_row_count) {
                vis_row_count = min_vis_row_count;
                RowAdjustments.this.fld_VIS_ROW_COUNT.setDouble(vis_row_count);
            }
            RowAdjustments.this.slider_VIS_ROW_COUNT.setValLabel(vis_row_count);
            row_height = (double)RowAdjustments.this.canvas_vport.getHeight() / vis_row_count;
            RowAdjustments.this.slider_VIS_ROW_HEIGHT.setValLabel(row_height);
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("RowCountTextListener: h=" + row_height + ",N=" + vis_row_count);
                RowAdjustments.this.debug.println("RowCountTextListener: END");
            }
        }
    }

    private class RowCountSliderListener
    implements ChangeListener {
        private RowCountSliderListener() {
        }

        public void stateChanged(ChangeEvent evt) {
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("RowCountSliderListener: START");
            }
            double row_height = -1.0;
            double vis_row_count = RowAdjustments.this.slider_VIS_ROW_COUNT.getValLabel();
            RowAdjustments.this.fld_VIS_ROW_COUNT.setDouble(vis_row_count);
            if (!RowAdjustments.this.slider_VIS_ROW_COUNT.getValueIsAdjusting()) {
                double min_vis_row_count = RowAdjustments.this.slider_VIS_ROW_COUNT.getMinLabel();
                double max_vis_row_count = RowAdjustments.this.slider_VIS_ROW_COUNT.getMaxLabel();
                if (vis_row_count > max_vis_row_count) {
                    vis_row_count = max_vis_row_count;
                    RowAdjustments.this.fld_VIS_ROW_COUNT.setDouble(vis_row_count);
                    RowAdjustments.this.slider_VIS_ROW_COUNT.setValLabelFully(vis_row_count);
                } else if (vis_row_count < min_vis_row_count) {
                    vis_row_count = min_vis_row_count;
                    RowAdjustments.this.fld_VIS_ROW_COUNT.setDouble(vis_row_count);
                    RowAdjustments.this.slider_VIS_ROW_COUNT.setValLabelFully(vis_row_count);
                }
                row_height = (double)RowAdjustments.this.canvas_vport.getHeight() / vis_row_count;
                RowAdjustments.this.slider_VIS_ROW_HEIGHT.setValLabel(row_height);
                if (RowAdjustments.this.debug.isActive()) {
                    RowAdjustments.this.debug.println("RowCountSliderListener: h=" + row_height + ",N=" + vis_row_count);
                }
            }
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("RowCountSliderListener: END");
            }
        }
    }

    private class RowHeightTextListener
    implements ActionListener {
        private RowHeightTextListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("RowHeightTextListener: START");
            }
            double vport_height = RowAdjustments.this.canvas_vport.getHeight();
            double tree_row_count = RowAdjustments.this.tree_view.getRowCount();
            double min_row_height = vport_height / tree_row_count;
            double max_row_height = vport_height;
            double vis_row_count = -1.0;
            double row_height = RowAdjustments.this.fld_VIS_ROW_HEIGHT.getDouble();
            if (row_height > max_row_height) {
                row_height = max_row_height;
                vis_row_count = 1.0;
                RowAdjustments.this.fld_VIS_ROW_HEIGHT.setDouble(row_height);
            } else if (row_height < min_row_height) {
                row_height = min_row_height;
                vis_row_count = tree_row_count;
                RowAdjustments.this.fld_VIS_ROW_HEIGHT.setDouble(row_height);
            } else {
                vis_row_count = vport_height / row_height;
            }
            RowAdjustments.this.slider_VIS_ROW_HEIGHT.setValLabel(row_height);
            RowAdjustments.this.slider_VIS_ROW_COUNT.setValLabel(vis_row_count);
            RowAdjustments.this.tree_view.setRowHeight((int)Math.round(row_height));
            RowAdjustments.this.canvas_vport.fireComponentResized();
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("RowHeightTextListener: h=" + row_height + ",N=" + vis_row_count);
                RowAdjustments.this.debug.println("RowHeightTextListener: END");
            }
        }
    }

    private class RowHeightSliderListener
    implements ChangeListener {
        private RowHeightSliderListener() {
        }

        public void stateChanged(ChangeEvent evt) {
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("RowHeightSliderListener: START");
            }
            double vis_row_count = -1.0;
            double row_height = RowAdjustments.this.slider_VIS_ROW_HEIGHT.getValLabel();
            RowAdjustments.this.fld_VIS_ROW_HEIGHT.setDouble(row_height);
            if (!RowAdjustments.this.slider_VIS_ROW_HEIGHT.getValueIsAdjusting()) {
                double vport_height = RowAdjustments.this.canvas_vport.getHeight();
                double tree_row_count = RowAdjustments.this.tree_view.getRowCount();
                double min_row_height = vport_height / tree_row_count;
                double max_row_height = vport_height;
                if (row_height > max_row_height) {
                    row_height = max_row_height;
                    vis_row_count = 1.0;
                    RowAdjustments.this.fld_VIS_ROW_HEIGHT.setDouble(row_height);
                    RowAdjustments.this.slider_VIS_ROW_HEIGHT.setValLabelFully(row_height);
                } else if (row_height < min_row_height) {
                    row_height = min_row_height;
                    vis_row_count = tree_row_count;
                    RowAdjustments.this.fld_VIS_ROW_HEIGHT.setDouble(row_height);
                    RowAdjustments.this.slider_VIS_ROW_HEIGHT.setValLabelFully(row_height);
                } else {
                    vis_row_count = vport_height / row_height;
                }
                RowAdjustments.this.slider_VIS_ROW_COUNT.setValLabel(vis_row_count);
                RowAdjustments.this.tree_view.setRowHeight((int)Math.round(row_height));
                RowAdjustments.this.canvas_vport.fireComponentResized();
                if (RowAdjustments.this.debug.isActive()) {
                    RowAdjustments.this.debug.println("RowHeightSliderListener: h=" + row_height + ",N=" + vis_row_count);
                }
            }
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("RowHeightSliderListener: END");
            }
        }
    }

    private class SliderComponentListener
    extends ComponentAdapter {
        private SliderComponentListener() {
        }

        public void componentResized(ComponentEvent evt) {
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("SliderComponentListener: START");
                RowAdjustments.this.debug.println("HEIGHT: canvas_vport.height = " + RowAdjustments.this.canvas_vport.getHeight());
            }
            RowAdjustments.this.slider_VIS_ROW_HEIGHT.setMaxLabel(RowAdjustments.this.canvas_vport.getHeight());
            String resize_mode = (String)RowAdjustments.this.combo_ROW_RESIZE.getSelectedItem();
            if (resize_mode.equals(RowAdjustments.ROW_COUNT_RESIZE)) {
                double vis_row_count = RowAdjustments.this.fld_VIS_ROW_COUNT.getDouble();
                double row_height = (double)RowAdjustments.this.canvas_vport.getHeight() / vis_row_count;
                RowAdjustments.this.tree_view.setRowHeight((int)Math.round(row_height));
                RowAdjustments.this.canvas_vport.fireComponentResized();
                if (RowAdjustments.this.debug.isActive()) {
                    RowAdjustments.this.debug.println("ROW: row_height = " + row_height);
                }
            } else if (resize_mode.equals(RowAdjustments.ROW_HEIGHT_RESIZE)) {
                double row_height = RowAdjustments.this.fld_VIS_ROW_HEIGHT.getDouble();
                RowAdjustments.this.slider_VIS_ROW_HEIGHT.setValLabel(row_height);
            }
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("SliderComponentListener: END");
            }
        }
    }

    private class ResizeModeActionListener
    implements ActionListener {
        private ResizeModeActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            String resize_mode;
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("ResizeModeActionListener: START");
            }
            if ((resize_mode = (String)RowAdjustments.this.combo_ROW_RESIZE.getSelectedItem()).equals(RowAdjustments.ROW_COUNT_RESIZE)) {
                Parameters.ROW_RESIZE_MODE = RowAdjustments.ROW_COUNT_RESIZE;
                RowAdjustments.this.initPanelsToRowCountMode();
            } else if (resize_mode.equals(RowAdjustments.ROW_HEIGHT_RESIZE)) {
                Parameters.ROW_RESIZE_MODE = RowAdjustments.ROW_HEIGHT_RESIZE;
                RowAdjustments.this.initPanelsToRowHeightMode();
            }
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("ResizeModeActionListener: END");
            }
        }
    }
}

