/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BoxLayout;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import viewer.common.Routines;
import viewer.zoomable.InfoDialog;

public class InfoDialogForTime
extends InfoDialog {
    private static final long serialVersionUID = 4000L;
    private static final String FORMAT = "#,##0.000000####";
    private static DecimalFormat fmt = null;
    private double click_time;

    public InfoDialogForTime(Frame frame, double time) {
        super(frame, "Time Info Box", time);
        this.click_time = time;
        this.init();
    }

    public InfoDialogForTime(Dialog dialog, double time) {
        super(dialog, "Time Info Box", time);
        this.click_time = time;
        this.init();
    }

    private void init() {
        if (fmt == null) {
            fmt = (DecimalFormat)NumberFormat.getInstance();
            fmt.applyPattern(FORMAT);
        }
        Container root_panel = this.getContentPane();
        root_panel.setLayout(new BoxLayout(root_panel, 1));
        StringBuffer textbuf = new StringBuffer();
        int num_cols = 0;
        int num_rows = 1;
        StringBuffer linebuf = new StringBuffer();
        linebuf.append("time = " + fmt.format(this.click_time));
        num_cols = linebuf.length();
        textbuf.append(linebuf.toString());
        JTextArea text_area = new JTextArea(textbuf.toString());
        int adj_num_cols = Routines.getAdjNumOfTextColumns(text_area, num_cols);
        text_area.setColumns(adj_num_cols);
        text_area.setRows(num_rows);
        text_area.setEditable(false);
        text_area.setLineWrap(true);
        JScrollPane scroller = new JScrollPane(text_area);
        scroller.setAlignmentX(0.0f);
        root_panel.add(scroller);
        root_panel.add(super.getCloseButtonPanel());
    }
}

