/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import base.drawable.Category;
import base.drawable.ColorAlpha;
import base.drawable.Topology;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import viewer.common.Parameters;

public class CategoryIcon
implements Icon {
    public static final CategoryIcon BLANK_ICON = new CategoryIcon();
    private static final int ICON_WIDTH = 35;
    private static final int ICON_HEIGHT = 21;
    private static final int ICON_HALF_WIDTH = 17;
    private static final int ICON_QUARTER_WIDTH = 8;
    private static final int ICON_HALF_HEIGHT = 10;
    private static final int ICON_QUARTER_HEIGHT = 5;
    private static final int XOFF = 3;
    private static final int YOFF = 2;
    private Topology topo;
    private final ColorAlpha color_orig;
    private Color color_shown;

    private CategoryIcon() {
        this.topo = null;
        this.color_orig = null;
        this.color_shown = null;
    }

    public CategoryIcon(Category type) {
        this.topo = type.getTopology();
        this.color_orig = type.getColor();
        this.color_shown = this.color_orig;
    }

    public CategoryIcon(Topology shape, Color color) {
        this.topo = shape;
        this.color_orig = new ColorAlpha(color, 255);
        this.color_shown = color;
    }

    public void setDisplayedColor(Color new_color) {
        this.color_shown = new_color;
    }

    public Color getDisplayedColor() {
        return this.color_shown;
    }

    public ColorAlpha getOriginalColor() {
        return this.color_orig;
    }

    public void resetColor() {
        this.color_shown = this.color_orig;
    }

    public int getIconWidth() {
        return 35;
    }

    public int getIconHeight() {
        return 21;
    }

    public void paintIcon(Component cmpo, Graphics g, int x, int y) {
        Color old_color = g.getColor();
        if (this.topo != null) {
            if (this.topo.isEvent()) {
                this.paintEventIcon(g, x, y);
            } else if (this.topo.isState()) {
                this.paintStateIcon(g, x, y);
            } else if (this.topo.isArrow()) {
                this.paintArrowIcon(g, x, y);
            } else {
                this.paintBlankIcon(g, x, y);
            }
        } else {
            this.paintBlankIcon(g, x, y);
        }
        g.setColor(old_color);
    }

    private void paintStateIcon(Graphics g, int x, int y) {
        g.setColor((Color)Parameters.BACKGROUND_COLOR.toValue());
        g.fillRect(x, y, 35, 21);
        int x1 = x;
        int y1 = y + 10;
        int x2 = x + 35 - 1;
        int y2 = y1;
        g.setColor(Color.red);
        g.drawLine(x1, y1, x2, y2);
        x1 = x + 3;
        y1 = y + 2;
        x2 = x1 + 35 - 1 - 6;
        y2 = y1 + 21 - 1 - 4;
        g.setColor(this.color_shown);
        g.fillRect(x1, y1, 29, 17);
        Parameters.STATE_BORDER.paintStateBorder((Graphics2D)g, this.color_shown, x1, y1, true, x2, y2, true);
    }

    private void paintArrowIcon(Graphics g, int x, int y) {
        g.setColor((Color)Parameters.BACKGROUND_COLOR.toValue());
        g.fillRect(x, y, 35, 21);
        g.setColor(this.color_shown);
        int x1 = x;
        int y1 = y + 10;
        int x2 = x + 35 - 1;
        int y2 = y1;
        g.drawLine(x1, y1, x2, y2);
        x1 = x2;
        y1 = y2;
        x2 = x1 - 8;
        y2 = y1 + 5;
        int x3 = x2;
        int y3 = y1 - 5;
        g.drawLine(x1, y1, x2, y2);
        g.drawLine(x1, y1, x3, y3);
        g.drawLine(x2, y2, x3, y3);
    }

    private void paintEventIcon(Graphics g, int x, int y) {
        g.setColor((Color)Parameters.BACKGROUND_COLOR.toValue());
        g.fillRect(x, y, 35, 21);
        int x1 = x;
        int y1 = y + 10;
        int x2 = x + 35 - 1;
        int y2 = y1;
        g.setColor(Color.red);
        g.drawLine(x1, y1, x2, y2);
        x1 = x + 3;
        y1 = y + 2;
        g.setColor(this.color_shown);
        g.fillArc(x1, y1, 29, 5, 0, 360);
        g.setColor(Color.white);
        g.drawArc(x1, y1, 29, 5, 0, 360);
        x1 = x + 17;
        y1 = y + 2 + 5;
        x2 = x1;
        y2 = y + 21 - 1 - 2;
        g.drawLine(x1, y1, x2, y2);
    }

    private void paintBlankIcon(Graphics g, int x, int y) {
        g.setColor((Color)Parameters.BACKGROUND_COLOR.toValue());
        g.fillRect(x, y, 35, 21);
    }
}

