/*
 * Decompiled with CFR 0.152.
 */
package viewer.convertor;

import java.awt.event.ActionListener;
import javax.swing.Timer;
import viewer.common.SwingWorker;
import viewer.convertor.AdvancingTextArea;
import viewer.convertor.InputStreamThread;
import viewer.convertor.WaitingContainer;

public class SwingProcessWorker
extends SwingWorker {
    private WaitingContainer container;
    private AdvancingTextArea textarea;
    private String[] exec_cmd_ary;
    private Timer process_timer;
    private ActionListener process_progress;
    private Process process;
    private InputStreamThread process_err_task;
    private InputStreamThread process_out_task;
    private int process_istatus;

    public SwingProcessWorker(WaitingContainer proc_container, AdvancingTextArea proc_textarea) {
        this.container = proc_container;
        this.textarea = proc_textarea;
        this.process_progress = null;
        this.process_timer = new Timer(500, this.process_progress);
        this.process_timer.setInitialDelay(0);
        this.process_timer.setCoalesce(true);
        this.process = null;
        this.process_err_task = null;
        this.process_out_task = null;
    }

    public void initialize(String[] command_strs, ActionListener progress_action) {
        this.exec_cmd_ary = command_strs;
        if (this.process_progress != null) {
            this.process_timer.removeActionListener(this.process_progress);
        }
        this.process_progress = progress_action;
        this.process_timer.addActionListener(this.process_progress);
        StringBuffer cmd_strbuf = new StringBuffer("Executing ");
        for (int idx = 0; idx < this.exec_cmd_ary.length; ++idx) {
            cmd_strbuf.append(this.exec_cmd_ary[idx] + " ");
        }
        cmd_strbuf.append("....");
        this.textarea.append(cmd_strbuf.toString());
        Runtime runtime = Runtime.getRuntime();
        try {
            this.process = runtime.exec(this.exec_cmd_ary);
            this.process_err_task = new InputStreamThread(this.process.getErrorStream(), "Error", this.textarea);
            this.process_out_task = new InputStreamThread(this.process.getInputStream(), "Output", this.textarea);
            this.process_istatus = Integer.MIN_VALUE;
            this.container.initializeWaiting();
        }
        catch (Throwable err) {
            this.textarea.append("\n> Ending with unexpected Exception! Details in stderr.");
            err.printStackTrace();
        }
    }

    public Object construct() {
        try {
            if (this.process_err_task != null) {
                this.process_err_task.start();
            }
            if (this.process_out_task != null) {
                this.process_out_task.start();
            }
            this.process_timer.start();
            this.process_istatus = this.process.waitFor();
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
        return null;
    }

    public void finished() {
        this.process_timer.stop();
        if (this.process_err_task != null) {
            this.process_err_task.stopRunning();
            this.process_err_task = null;
        }
        if (this.process_out_task != null) {
            this.process_out_task.stopRunning();
            this.process_out_task = null;
        }
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        this.textarea.append("\n> Ending with exit status " + this.process_istatus + "\n");
        this.container.finalizeWaiting();
    }

    public boolean isEndedNormally() {
        return this.process_istatus == 0;
    }
}

